/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import com.ge.med.terra.jami.render.XpOverlayFilter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class T3DImageBlitter
extends XpJImage2DRenderer {
    public static final int RGB = 1;
    public static final int LUMINANCE16 = 11;
    private int mode = 11;
    private int[][] rgb_display = null;
    private short[][] lum_display = null;
    private XpMedicalImage[] rgb_medimage = null;
    private XpMedicalImage[] lum_medimage = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private XpColorOverlay overlay = null;
    private short[] disp_outoverlay = null;
    private XpOverlayFilter overlay_filter = null;
    private int[] overlay_cmap = new int[65536];
    private XpImagePixelAttributes[] initialPixelAttributes = new XpImagePixelAttributes[16];
    private boolean[] setWindowing = new boolean[this.initialPixelAttributes.length];
    private double[] defWW = new double[this.initialPixelAttributes.length];
    private double[] defWL = new double[this.initialPixelAttributes.length];

    private void updateT3DImages() {
        this.updateImage();
        this.clearIPA();
    }

    public int getNumOutputs() {
        if (this.lum_medimage != null) {
            return this.lum_medimage.length;
        }
        return 0;
    }

    public XpMedicalImage getMedicalImage(int layerNo) {
        if (this.mode == 11) {
            if (this.lum_medimage != null && layerNo < this.lum_medimage.length) {
                return this.lum_medimage[layerNo];
            }
        } else if (this.mode == 1 && this.rgb_medimage != null && layerNo < this.rgb_medimage.length) {
            return this.rgb_medimage[layerNo];
        }
        return null;
    }

    public Object getPixelBuffer(int layerNo) {
        if (this.mode == 11) {
            if (this.lum_display != null && layerNo < this.lum_display.length) {
                return this.lum_display[layerNo];
            }
        } else if (this.mode == 1 && this.rgb_display != null && layerNo < this.rgb_display.length) {
            return this.rgb_display[layerNo];
        }
        return null;
    }

    public BufferedImage getDisplayBuffer() {
        int mode = this.getMode();
        if (mode == 1 && this.rgb_medimage.length > 0) {
            return (BufferedImage)this.rgb_medimage[0].getPixelData();
        }
        if (this.lum_medimage.length > 0) {
            return (BufferedImage)this.lum_medimage[0].getPixelData();
        }
        return null;
    }

    public XpMedicalImage getRGBBuffer() {
        if (this.rgb_medimage != null && this.rgb_medimage.length > 0) {
            return this.rgb_medimage[0];
        }
        return null;
    }

    public XpMedicalImage getLuminanceBuffer() {
        if (this.lum_medimage != null && this.lum_medimage.length > 0) {
            return this.lum_medimage[0];
        }
        return null;
    }

    public void setSlice(CPoint ul, CPoint ur, CPoint br, double spx, double spy) {
        XpSlice sl;
        int i;
        if (this.lum_medimage != null) {
            for (i = 0; i < this.lum_medimage.length; ++i) {
                if (this.lum_medimage[i] == null) continue;
                sl = this.lum_medimage[i].getSlice();
                sl.pixelSizeX = spx;
                sl.pixelSizeY = spy;
                sl.setCorners(ul, ur, br);
            }
        }
        if (this.rgb_medimage != null) {
            for (i = 0; i < this.rgb_medimage.length; ++i) {
                if (this.rgb_medimage[i] == null) continue;
                sl = this.rgb_medimage[i].getSlice();
                sl.pixelSizeX = spx;
                sl.pixelSizeY = spy;
                sl.setCorners(ul, ur, br);
            }
        }
    }

    public void setRescaleLayer(double rescaleSlope, double rescaleIntercept, int layerNo) {
        XpBufferedImage xbi;
        if (this.lum_medimage != null && layerNo < this.lum_medimage.length && (xbi = (XpBufferedImage)this.lum_medimage[layerNo]) != null) {
            xbi.setRescaleIntercept(rescaleIntercept);
            xbi.setRescaleSlope(rescaleSlope);
        }
    }

    public void syncColorOverlay() {
        XpImageRenderAttributes ira = this.getAttributes();
        XpColorOverlay coverlay = ira.getColorOverlay();
        if (coverlay != this.overlay) {
            ira.setColorOverlay(this.overlay);
            this.setImageRenderAttributes(ira);
        }
    }

    public void setOverlayColorMap(int[] cmap) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        Arrays.fill(this.overlay_cmap, 0);
        if (cmap != null) {
            for (int i = 0; i < cmap.length; ++i) {
                this.overlay_cmap[i] = cmap[i];
            }
            ira.setColorOverlay(this.overlay);
        } else {
            ira.setColorOverlay(null);
        }
        this.setImageRenderAttributes(ira);
    }

    public boolean updateOverlayFilter(XpOverlayFilter filter) {
        this.overlay_filter = filter;
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira.getColorOverlay() != null && this.imgWidth > 0 && this.imgHeight > 0) {
            this.overlay = new XpColorOverlay(this.disp_outoverlay, this.overlay_cmap, this.overlay_filter, this.imgWidth, this.imgHeight);
            ira.setColorOverlay(this.overlay);
            this.setImageRenderAttributes(ira);
            return true;
        }
        return false;
    }

    public XpOverlayFilter getOverlayFilter() {
        return this.overlay_filter;
    }

    public void updateOverlay(short[] outoverlay) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null && ira.getColorOverlay() != null) {
            System.arraycopy(outoverlay, 0, this.disp_outoverlay, 0, outoverlay.length);
        }
    }

    public int getOutputWidth() {
        return this.imgWidth;
    }

    public int getOutputHeight() {
        return this.imgHeight;
    }

    public void restoreFromOutput(Object pbuffer, int layerNo) {
        int[][] _rgb_display = this.rgb_display;
        short[][] _lum_display = this.lum_display;
        if (layerNo >= _rgb_display.length) {
            return;
        }
        if (pbuffer instanceof int[]) {
            System.arraycopy(_rgb_display[layerNo], 0, pbuffer, 0, _rgb_display[layerNo].length);
        } else {
            System.arraycopy(_lum_display[layerNo], 0, pbuffer, 0, _lum_display[layerNo].length);
        }
    }

    public void sendToOutput(T3DRenderEngine engine, Object pbuffer, int layerNo) {
        if (pbuffer instanceof int[]) {
            System.arraycopy(pbuffer, 0, this.rgb_display[layerNo], 0, this.rgb_display[layerNo].length);
        } else {
            double rescaleSlope = engine.getRescaleSlope(layerNo);
            double rescaleIntercept = engine.getRescaleIntercept(layerNo);
            double imgSlope = this.lum_medimage[layerNo].getRescaleSlope();
            double imgIntercept = this.lum_medimage[layerNo].getRescaleIntercept();
            if (imgSlope != rescaleSlope || imgIntercept != rescaleIntercept) {
                this.setRescaleLayer(rescaleSlope, rescaleIntercept, layerNo);
            }
            System.arraycopy(pbuffer, 0, this.lum_display[layerNo], 0, this.lum_display[layerNo].length);
        }
    }

    public void clearOutputBuffers() {
        if (this.rgb_display != null && this.lum_display != null) {
            int i;
            for (i = 0; i < this.rgb_display.length; ++i) {
                Arrays.fill(this.rgb_display[i], 0);
            }
            for (i = 0; i < this.lum_display.length; ++i) {
                Arrays.fill(this.lum_display[i], (short)0);
            }
        }
    }

    public boolean updateSize(T3DRenderEngine engine, int noutputs, int width, int height) {
        if (this.disp_outoverlay == null || this.imgWidth != width || this.imgHeight != height) {
            this.disp_outoverlay = new short[width * height];
            this.overlay = new XpColorOverlay(this.disp_outoverlay, this.overlay_cmap, this.overlay_filter, width, height);
        }
        this.imgWidth = width;
        this.imgHeight = height;
        if (this.rgb_display == null || this.rgb_display.length != noutputs) {
            int[][] nrgb = new int[noutputs][];
            short[][] nlum = new short[noutputs][];
            XpMedicalImage[] nrgbmed = new XpMedicalImage[noutputs];
            XpMedicalImage[] nlummed = new XpMedicalImage[noutputs];
            int currlen = this.rgb_display != null ? this.rgb_display.length : 0;
            int min = Math.min(noutputs, currlen);
            for (int i = 0; i < min; ++i) {
                nrgb[i] = this.rgb_display[i];
                nlum[i] = this.lum_display[i];
                nrgbmed[i] = this.rgb_medimage[i];
                nlummed[i] = this.lum_medimage[i];
            }
            this.rgb_display = nrgb;
            this.lum_display = nlum;
            this.rgb_medimage = nrgbmed;
            this.lum_medimage = nlummed;
        }
        boolean resizeTheBuffers = false;
        ArrayList<XpImageLayer> imgLayers = null;
        for (int i = 0; i < noutputs; ++i) {
            XjVolumeInfo vol;
            if (this.rgb_display[i] != null && this.rgb_medimage[i] != null && this.rgb_medimage[i].getSlice().width == width && this.rgb_medimage[i].getSlice().height == height) continue;
            double rescaleIntercept = engine.getRescaleIntercept(i);
            double rescaleSlope = engine.getRescaleSlope(i);
            double ww = 800.0;
            double wl = 400.0;
            XjVolumeModel vm = engine.getVolumeModel(i);
            if (vm != null && (vol = vm.getVolume()) != null) {
                ww = XjVolumeUtils.calcVolumeDefWW(vol);
                wl = XjVolumeUtils.calcVolumeDefWL(vol);
            }
            resizeTheBuffers = true;
            BufferedImage rgb = new BufferedImage(width, height, 1);
            BufferedImage lum = new BufferedImage(width, height, 11);
            this.rgb_display[i] = ((DataBufferInt)rgb.getRaster().getDataBuffer()).getData();
            this.lum_display[i] = ((DataBufferUShort)lum.getRaster().getDataBuffer()).getData();
            this.rgb_medimage[i] = new XpBufferedImage(rgb);
            this.lum_medimage[i] = new XpBufferedImage(lum, rescaleIntercept, rescaleSlope);
            if (i <= 0) continue;
            if (imgLayers == null) {
                imgLayers = new ArrayList<XpImageLayer>();
            }
            XpImagePixelAttributes ipa = this.getImagePixelAttributes(i, ww, wl);
            XpImageLayer il = new XpImageLayer(this.lum_medimage[i], ipa);
            imgLayers.add(il);
        }
        final ArrayList<XpImageLayer> layers = imgLayers;
        Runnable r = new Runnable(){

            public void run() {
                if (T3DImageBlitter.this.lum_medimage.length > 0 && T3DImageBlitter.this.rgb_medimage.length > 0) {
                    T3DImageBlitter.this.updateT3DImages();
                    T3DImageBlitter.this.setImageLayers(layers);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return resizeTheBuffers;
    }

    public int getMode() {
        return this.mode;
    }

    private void updateImage() {
        if (this.mode == 1) {
            this.setImage(this.rgb_medimage[0]);
        } else if (this.mode == 11) {
            this.setImage(this.lum_medimage[0]);
        }
        this.refreshImage();
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.updateImage();
        }
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layerNo, double defaultWW, double defaultWL) {
        XpImagePixelAttributes ipa = this.getIPA(layerNo);
        this.defWW[layerNo] = defaultWW;
        this.defWL[layerNo] = defaultWL;
        if (!this.setWindowing[layerNo]) {
            ipa.setWindowing(defaultWW, defaultWL);
        }
        return ipa;
    }

    public void clearIPA() {
        for (int i = 0; i < this.initialPixelAttributes.length; ++i) {
            this.initialPixelAttributes[i] = null;
            this.setWindowing[i] = false;
        }
    }

    public void clearIPA(int layerNo) {
        this.initialPixelAttributes[layerNo] = null;
        this.setWindowing[layerNo] = false;
    }

    public XpImagePixelAttributes getIPA(int layerNo) {
        XpImagePixelAttributes ipa = this.initialPixelAttributes[layerNo];
        if (ipa == null) {
            ipa = new XpImagePixelAttributes();
        }
        this.initialPixelAttributes[layerNo] = ipa;
        return ipa;
    }

    public void setColorMap(int layerNo, int[] cmap) {
        XpImagePixelAttributes ipa = this.getIPA(layerNo);
        ipa.setColormap(cmap);
        List l = this.getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layerNo - 1);
            il.setColorMap(cmap);
        }
    }

    public void setInverseVideo(int layerNo, boolean ivideo) {
        XpImagePixelAttributes ipa = this.getIPA(layerNo);
        ipa.setVideoInverted(ivideo);
        List l = this.getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layerNo - 1);
            il.setVideoInverted(ivideo);
        }
    }

    public void setWindowing(int layerNo, double ww, double wl) {
        XpImagePixelAttributes ipa = this.getIPA(layerNo);
        ipa.setWindowing(ww, wl);
        this.setWindowing[layerNo] = true;
        List l = this.getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layerNo - 1);
            il.setWindowing(ww, wl);
        }
    }

    public void resetWindowing(int layerNo) {
        XpImagePixelAttributes ipa = this.getIPA(layerNo);
        ipa.reset();
        List l = this.getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layerNo - 1);
            il.resetWindowing();
        }
    }
}

