/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.OffScreenCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.T3DStateCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjFragmentProgram;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpRASAnnotation;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.DefaultT3DMouseController;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DSerializer;
import com.ge.med.terra.jami.j3d.remote.RmClient3DEngine;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import com.ge.med.terra.jami.roi.j3d.T3DStatImage;
import com.ge.med.terra.jami.roi.j3d.Xp3DRoiVc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class T3DViewport
extends XpViewport
implements T3DCapable,
FrameOwner,
XpImageRenderAttributesOwner,
WindowLevelCapable,
ColorMapCapable,
ROICapable,
UserAnnoCapable,
OffScreenCapable,
T3DRenderStyleCapable,
T3DStateCapable,
ActiveAnnotationCapable,
AnnotCapable,
Selectable,
ComponentCreationListener {
    T3DSerializer serializer = null;
    private T3DComponent tc = null;
    private XpMouseController mc = null;
    private XpDicomObject dobj = null;
    private XpAnnotationGenerator ag = null;
    private XpAnnotationVc annotVc = new XpAnnotationVc();
    private Map rois = new HashMap();
    private Map uannos = new HashMap();
    private List roilist = new ArrayList();
    private List uannolist = new ArrayList();
    private ComponentCreator componentCreator = null;
    private Cursor oldCursor = null;
    public static final ImageIcon CROSS_ICON = new ImageIcon(XpSingularPort.class.getResource("measureCursor.gif"));
    public static final Cursor MEASUREMENT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(CROSS_ICON.getImage(), new Point(CROSS_ICON.getIconWidth() / 2, CROSS_ICON.getIconHeight() / 2), "Measurement");
    private Properties annotationGeneratorProps;
    private MouseListener selectionListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            T3DViewport.this.firePropertyChange("COMPONENT_SELECTED", false, true);
        }
    };
    private boolean selected_ = false;

    public static JFrame showVolume(XjVolumeInfo volinfo) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        T3DViewport vp = new T3DViewport();
        vp.setPreferredSize(new Dimension(512, 512));
        f.setContentPane(vp);
        f.pack();
        f.setVisible(true);
        vp.setVolume(volinfo);
        return f;
    }

    public T3DViewport() {
        this(new T3DComponent());
    }

    public T3DViewport(T3DComponent tc) {
        this.setT3DComponent(tc);
        this.initViewport();
    }

    public T3DViewport(T3DRenderEngine engine) {
        T3DComponent tc = new T3DComponent(engine);
        this.setT3DComponent(tc);
        this.initViewport();
    }

    public T3DViewport(RmRenderSession serverSession, String remoteRenderEngineClass) {
        RmClient3DEngine client_re = new RmClient3DEngine(serverSession, remoteRenderEngineClass);
        T3DComponent tc = new T3DComponent((T3DRenderEngine)client_re);
        this.setT3DComponent(tc);
        this.initViewport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        T3DViewport vp;
        try {
            vp = (T3DViewport)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            vp = new T3DViewport();
        }
        catch (IllegalAccessException e) {
            vp = new T3DViewport();
        }
        vp.setAnnotationGenerator(this.getAnnotationGenerator().getClass(), this.annotationGeneratorProps);
        vp.setVolumeModel(this.getVolumeModel());
        int volumeLayers = this.tc.getNumVolumeLayers();
        T3DComponent vpT3Dcomp = vp.getT3DComponent();
        for (int i = 1; i < volumeLayers; ++i) {
            vpT3Dcomp.addVolumeLayer(this.tc.getVolumeModel(i));
        }
        vp.getT3DComponent().setPixelCombiner(this.tc.getPixelCombiner());
        int layer = this.tc.getVolumeLayer();
        for (int i = 0; i < volumeLayers; ++i) {
            this.tc.selectVolumeLayer(i);
            vpT3Dcomp.selectVolumeLayer(i);
            vpT3Dcomp.setWinMinMax(this.tc.getWinMin(), this.tc.getWinMax());
            vpT3Dcomp.setVideoInverted(this.tc.isVideoInverted());
            int[] colorMap = this.tc.getColorMap();
            if (colorMap == null) continue;
            vpT3Dcomp.setColorMap(colorMap);
        }
        this.tc.selectVolumeLayer(layer);
        vpT3Dcomp.selectVolumeLayer(layer);
        vp.setT3DState(this.getT3DState());
        vp.setViewHeight(this.getViewHeight());
        vp.setSize(this.getSize());
        vp.setPreferredSize(this.getPreferredSize());
        vp.getT3DComponent().setSize(this.getT3DComponent().getSize());
        vp.forceRenderContents();
        T3DComponent tc = this.getT3DComponent();
        for (int i = 0; i < tc.getComponentCount(); ++i) {
            Component c = tc.getComponent(i);
            if (c instanceof Xp3DRoiVc) {
                Xp3DRoiVc roivc = (Xp3DRoiVc)c;
                RoiActor ra = roivc.getRoiActor();
                if (!(ra instanceof XpStatisticsRoi)) continue;
                XpStatisticsRoi sr = (XpStatisticsRoi)ra;
                RoiActor newroi = (RoiActor)sr.clone();
                T3DStatImage origImg = (T3DStatImage)sr.getImage();
                T3DStatImage tsi = new T3DStatImage(vp, newroi, origImg.getReferenceSlice());
                Xp3DRoiVc newroivc = null;
                try {
                    Constructor<?> construct = c.getClass().getConstructor(RoiActor.class, Boolean.TYPE, Boolean.TYPE);
                    newroivc = (Xp3DRoiVc)construct.newInstance(newroi, roivc.isViewLock(), true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                finally {
                    if (newroivc == null) {
                        newroivc = new Xp3DRoiVc(newroi, roivc.isViewLock(), true);
                    }
                }
                newroi.setImage((XpImage)tsi);
                vp.getT3DComponent().add((Component)newroivc);
                newroi.setSelected(false);
                continue;
            }
            if (c instanceof XpUserAnnotationVc) {
                XpUserAnnotationVc userAnnoVc = (XpUserAnnotationVc)c;
                XpUserAnnotationModel userAnnotationModel = userAnnoVc.getUserAnnotationModel();
                XpUserAnnotationModel new_model = (XpUserAnnotationModel)userAnnotationModel.clone();
                vp.add(new_model);
                new_model.setSelected(false);
                continue;
            }
            try {
                Method m = c.getClass().getMethod("clone", new Class[0]);
                int mod = m.getModifiers();
                if (!Modifier.isPublic(mod)) continue;
                Component clone_c = (Component)m.invoke((Object)c, new Object[0]);
                vp.getT3DComponent().add(clone_c);
                continue;
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e1) {
                continue;
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
        vp.invalidate();
        vp.validate();
        return vp;
    }

    public void forceRenderContents() {
        this.tc.forceRenderContents();
    }

    private void initViewport() {
        this.setAnnotationGenerator(T3DAnnotationGenerator.class, null);
        this.setBackground(Color.black);
        this.setLayout(new XpStackLayout());
        this.add(this.tc);
        this.tc.add((Component)this.annotVc, 0);
        DefaultT3DMouseController rmc = new DefaultT3DMouseController();
        this.setMouseController(rmc);
        this.addMouseWheelListener(rmc);
        this.serializer = new T3DSerializer(this);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.tc != null) {
            this.tc.setBackground(bg);
        }
    }

    public void dispose() {
        super.dispose();
        this.setMouseController(null);
        if (this.ag != null) {
            this.ag.reset();
        }
        this.dobj = null;
        this.ag = null;
        if (this.tc != null) {
            this.remove(this.tc);
            this.tc.dispose();
            this.tc.remove(this.annotVc);
            this.tc = null;
            this.annotVc = null;
        }
    }

    public final void setRenderStyle(String style) {
        this.tc.setRenderStyle(style);
    }

    public final String getRenderStyle() {
        return this.tc.getRenderStyle();
    }

    private void setT3DComponent(T3DComponent tc) {
        if (this.tc != null) {
            this.tc.removeMouseListener(this.selectionListener);
        }
        this.tc = tc;
        tc.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                T3DViewport.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public Capable getCapable(String capableIFName) {
        Capable c = super.getCapable(capableIFName);
        if (c == null && this.tc != null) {
            c = this.tc.getCapable(capableIFName);
        }
        return c;
    }

    public final void setAnnotationGenerator(Class agClass, Properties props) {
        try {
            this.ag = (XpAnnotationGenerator)agClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.ag != null) {
                this.annotationGeneratorProps = props;
                this.ag.setProperties(props);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public final XpAnnotationGenerator getAnnotationGenerator() {
        return this.ag;
    }

    private void cleanup() {
        this.ag.reset();
    }

    public void setVolume(XjVolumeInfo volume) {
        this.cleanup();
        if (volume == null) {
            this.dobj = null;
            this.tc.setVolume(null);
            this.init();
            return;
        }
        this.dobj = new DicomSource(volume);
        this.init();
        this.tc.setVolume(volume);
        this.repaint();
    }

    public XpDicomObject getDicomSource() {
        return this.dobj;
    }

    private void init() {
        if (this.dobj != null) {
            XpAnnotationModel annotModel = null;
            if (this.ag instanceof XpApdAnnotationGenerator) {
                XpApdAnnotationGenerator apd_ag = (XpApdAnnotationGenerator)this.ag;
                annotModel = apd_ag.getAnnotation(this.dobj);
            } else {
                annotModel = this.ag.getAnnotation(this.tc.getMedicalImage(), this.dobj);
            }
            this.annotVc.setAnnotationModel(annotModel);
            XpImageRenderAttributes ira = this.tc.getImageRenderAttributes();
            double wl = 600.0;
            double ww = 1200.0;
            ira.setWindowing(ww, wl);
            this.tc.setImageRenderAttributes(ira);
        } else {
            this.annotVc.setAnnotationModel(null);
        }
    }

    public void setProperty(String propName, Object value) {
        this.tc.setProperty(propName, value);
        this.repaint();
    }

    public Object getProperty(String propName) {
        return this.tc.getProperty(propName);
    }

    public final XpImage getFrame() {
        return this.tc.getFrame();
    }

    public final T3DComponent getT3DComponent() {
        return this.tc;
    }

    public final XpAnnotationVc getAnnotationVc() {
        return this.annotVc;
    }

    public XpMedicalImage[] getImages() {
        XpMedicalImage[] imgs = new XpMedicalImage[]{this.tc.getMedicalImage()};
        return imgs;
    }

    public void refreshContents() {
        this.tc.refresh();
    }

    public XpImage getImageAt(int idx) {
        return this.tc.getFrame();
    }

    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.tc.getWorldBounds(ulc, xside, yside, zside);
    }

    public void setLookPoint(double[] point) {
        this.tc.setLookPoint(point);
    }

    public double[] getLookPoint(double[] look_pt) {
        return this.tc.getLookPoint(look_pt);
    }

    public void setEyePoint(double[] point) {
        this.tc.setEyePoint(point);
    }

    public double[] getEyePoint(double[] eye_pt) {
        return this.tc.getEyePoint(eye_pt);
    }

    public void setUp(double[] vec) {
        this.tc.setUp(vec);
    }

    public double[] getUp(double[] up_v) {
        return this.tc.getUp(up_v);
    }

    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.tc.setCamera(eyepoint, lookpoint, up);
    }

    public void setViewHeight(double height) {
        this.tc.setViewHeight(height);
    }

    public double getViewHeight() {
        return this.tc.getViewHeight();
    }

    public void setAspectRatio(double aspect) {
        this.tc.setAspectRatio(aspect);
    }

    public double getAspectRatio() {
        return this.tc.getAspectRatio();
    }

    public void setViewClip(double[] clipOffsets) {
        this.tc.setViewClip(clipOffsets);
    }

    public double[] getViewClip(double[] view_clip) {
        return this.tc.getViewClip(view_clip);
    }

    public void setPerspective(boolean b2) {
        this.tc.setPerspective(b2);
    }

    public boolean isPerspective() {
        return this.tc.isPerspective();
    }

    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.tc.setImageRenderAttributes(attr);
    }

    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.tc.getImageRenderAttributes();
    }

    public synchronized void setWindowing(double width, double level) {
        this.tc.setWindowing(width, level);
        this.auto_repaint();
    }

    public void setWinMinMax(double min, double max) {
        this.tc.setWinMinMax(min, max);
    }

    public double getWinMin() {
        return this.tc.getWinMin();
    }

    public final void setWinMin(double min) {
        this.tc.setWinMin(min);
    }

    public double getWinMax() {
        return this.tc.getWinMax();
    }

    public final void setWinMax(double max) {
        this.tc.setWinMax(max);
    }

    public void resetWindowing() {
        this.tc.resetWindowing();
        this.auto_repaint();
    }

    public final void setWinUpperLimit(double wuLimit) {
        this.tc.setWinUpperLimit(wuLimit);
    }

    public final double getWinUpperLimit() {
        return this.tc.getWinUpperLimit();
    }

    public final void setWinLowerLimit(double wlLimit) {
        this.tc.setWinLowerLimit(wlLimit);
    }

    public final double getWinLowerLimit() {
        return this.tc.getWinLowerLimit();
    }

    public void setVideoInverted(boolean inverted) {
        this.tc.setVideoInverted(inverted);
        this.auto_repaint();
    }

    public boolean isVideoInverted() {
        return this.tc.isVideoInverted();
    }

    public double[] getRange() {
        return this.tc.getRange();
    }

    protected Component addComponent(Component c) {
        RoiActor ra;
        Component retcomp = this.tc.add(c);
        this.invalidate();
        this.validate();
        this.repaint();
        if (c instanceof XpImageRoiVc && (ra = ((XpImageRoiVc)c).getRoiActor()) != null) {
            this.firePropertyChange("ROI_ADDED", null, ra, this);
        }
        return retcomp;
    }

    protected void removeComponent(Component c) {
        RoiActor ra;
        this.tc.remove(c);
        this.invalidate();
        this.validate();
        this.repaint();
        if (c instanceof XpImageRoiVc && (ra = ((XpImageRoiVc)c).getRoiActor()) != null) {
            this.firePropertyChange("ROI_REMOVED", null, ra, this);
        }
    }

    public void add(RoiActor ra) {
        XpImageRoiVc rvc = (XpImageRoiVc)this.rois.get(ra);
        if (rvc == null) {
            rvc = new Xp3DRoiVc(ra);
            this.roilist.add(ra);
            this.rois.put(ra, rvc);
            ra.setImage((XpImage)new T3DStatImage(this, ra));
            this.addComponent(rvc);
        }
    }

    public Component add(Component comp) {
        if (comp instanceof XpImageRoiVc) {
            XpImageRoiVc roi3d = (XpImageRoiVc)comp;
            RoiActor ra = roi3d.getRoiActor();
            this.roilist.add(ra);
            this.rois.put(ra, roi3d);
            if (!(ra.getImage() instanceof Roi3DStatImage)) {
                ra.setImage((XpImage)new T3DStatImage(this, ra));
            }
            return this.addComponent(comp);
        }
        return super.add(comp);
    }

    public void remove(Component comp) {
        if (comp instanceof XpImageRoiVc) {
            XpImageRoiVc roi3d = (XpImageRoiVc)comp;
            RoiActor ra = roi3d.getRoiActor();
            this.roilist.remove(ra);
            this.rois.remove(ra);
            ra.setImage(null);
            this.removeComponent(comp);
        }
        super.remove(comp);
    }

    public List getRois() {
        return this.roilist;
    }

    public boolean remove(RoiActor ra) {
        XpImageRoiVc rvc = (XpImageRoiVc)this.rois.get(ra);
        if (rvc != null) {
            this.roilist.remove(ra);
            this.rois.remove(ra);
            ra.setImage(null);
            this.removeComponent(rvc);
            return true;
        }
        return false;
    }

    public RoiActor getRoi() {
        int len = this.roilist.size();
        if (len > 0) {
            return (RoiActor)this.roilist.get(len - 1);
        }
        return null;
    }

    public void setComponentCreator(ComponentCreator rc) {
        if (this.componentCreator != null) {
            this.getT3DComponent().setCursor(this.oldCursor);
            this.componentCreator.removeViewport(this, this.getT3DComponent());
            this.componentCreator.removeComponentCreationListener(this);
            this.componentCreator = null;
        }
        this.componentCreator = rc;
        if (rc != null) {
            rc.addViewport(this, this.getT3DComponent());
            rc.addComponentCreationListener(this);
            this.oldCursor = this.getT3DComponent().getCursor();
            this.disableMouseController();
            this.getT3DComponent().setCursor(MEASUREMENT_CURSOR);
        } else {
            this.enableMouseController();
        }
    }

    public ComponentCreator getComponentCreator() {
        return this.componentCreator;
    }

    public void add(XpUserAnnotationModel m) {
        XpUserAnnotationVc uvc = (XpUserAnnotationVc)this.uannos.get(m);
        if (uvc == null) {
            uvc = new XpUserAnnotationVc(m);
            this.uannolist.add(m);
            this.uannos.put(m, uvc);
            this.addComponent(uvc);
        }
    }

    public boolean remove(XpUserAnnotationModel m) {
        XpUserAnnotationVc uvc = (XpUserAnnotationVc)this.uannos.get(m);
        if (uvc != null) {
            this.uannolist.remove(m);
            this.uannos.remove(m);
            this.removeComponent(uvc);
            return true;
        }
        return false;
    }

    public List getUserAnnos() {
        return this.uannolist;
    }

    public XjVolumeModel getVolumeModel() {
        return this.tc.getVolumeModel();
    }

    public XjVolumeInfo getVolume() {
        return this.tc.getVolume();
    }

    public void setOverlayColorMap(int[] cmap) {
        this.tc.setOverlayColorMap(cmap);
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.cleanup();
        if (vm instanceof XpDicomObject) {
            this.dobj = (XpDicomObject)((Object)vm);
        } else if (vm == null) {
            this.dobj = null;
        }
        this.init();
        this.tc.setVolumeModel(vm);
        this.repaint();
    }

    public final XpMouseController getMouseController() {
        return this.mc;
    }

    public void disableMouseController() {
        if (this.mc != null) {
            this.mc.setTarget(null);
            this.tc.removeMouseListener(this.mc);
            this.tc.removeMouseMotionListener(this.mc);
            if (this.mc instanceof PropertyChangeListener) {
                this.tc.removePropertyChangeListener((PropertyChangeListener)((Object)this.mc));
            }
            if (this.mc instanceof MouseWheelListener) {
                this.removeMouseWheelListener((MouseWheelListener)((Object)this.mc));
            }
        }
    }

    public void enableMouseController() {
        if (this.mc != null) {
            this.mc.setTarget(this);
            this.tc.addMouseListener(this.mc);
            this.tc.addMouseMotionListener(this.mc);
            if (this.mc instanceof MouseWheelListener) {
                this.addMouseWheelListener((MouseWheelListener)((Object)this.mc));
            }
        }
        this.tc.removeMouseListener(this.selectionListener);
        this.tc.addMouseListener(this.selectionListener);
    }

    protected MouseListener getSelectionListener() {
        return this.selectionListener;
    }

    public final void setMouseController(XpMouseController mc) {
        if (mc != this.mc) {
            this.disableMouseController();
            this.mc = mc;
            this.enableMouseController();
            if (mc != null) {
                mc.setTarget(this);
            }
        }
        this.tc.removeMouseListener(this.selectionListener);
        this.tc.addMouseListener(this.selectionListener);
    }

    public final BufferedImage getImage(BufferedImage img, String options) {
        BufferedImage bi = img;
        if (bi == null) {
            Dimension d = this.getSize();
            bi = new BufferedImage(d.width, d.height, 2);
        }
        if (options != null) {
            String[] toks = options.split("=\\s");
            int i = 0;
            while (i < toks.length) {
                if (toks[i].equals("annotation")) {
                    if (toks[i + 1].equals("off")) {
                        this.annotVc.setVisible(false);
                        i += 2;
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (toks[i].equals("graphics")) {
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        int type = bi.getType();
        switch (type) {
            case 2: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                XpBufferedImage xbi = (XpBufferedImage)this.getFrame();
                BufferedImage bimg = (BufferedImage)xbi.getPixelData();
                if (bimg.getWidth() != bi.getWidth() || bimg.getHeight() != bi.getHeight() || bimg.getType() != 11) break;
                short[] sdata = ((DataBufferUShort)bimg.getRaster().getDataBuffer()).getData();
                short[] ddata = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
                System.arraycopy(sdata, 0, ddata, 0, sdata.length);
            }
        }
        return bi;
    }

    public String[] getSupportedRenderStyles() {
        return this.tc.getSupportedRenderStyles();
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.tc.addTaskMonitor(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.tc.removeTaskMonitor(tm);
    }

    public InputStream getT3DState() {
        return this.serializer.getT3DState();
    }

    public void setT3DState(InputStream t3dStateStream) {
        this.serializer.setT3DState(t3dStateStream);
        this.firePropertyChange("t3dstate", null, null);
    }

    public Border getBorder() {
        if (this.tc != null) {
            return this.tc.getBorder();
        }
        return super.getBorder();
    }

    public void setBorder(Border b2) {
        if (this.tc != null) {
            this.tc.setBorder(b2);
        } else {
            super.setBorder(b2);
        }
    }

    public double[] getInitialUp() {
        return this.tc.getInitialUp();
    }

    public void setInitialUp(double[] initialUp) {
        this.tc.setInitialUp(initialUp);
    }

    public double[] getInitialView() {
        return this.tc.getInitialView();
    }

    public void setInitialView(double[] initialView) {
        this.tc.setInitialView(initialView);
    }

    public void setAutoRepaint(boolean autoRepaint) {
        super.setAutoRepaint(autoRepaint);
        if (this.tc != null) {
            this.tc.setAutoRepaint(autoRepaint);
        }
    }

    public String[] getAnnotationSegments() {
        return this.getAnnotationVc().getAnnotationSegments();
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        this.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil);
    }

    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        this.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil, tooltip);
    }

    public void clearActiveAnnotationListener(String annotSegment) {
        this.getAnnotationVc().clearActiveAnnotationListener(annotSegment);
    }

    public void clearActiveAnnotationListeners() {
        this.getAnnotationVc().clearActiveAnnotationListeners();
    }

    protected void applyAnnotationLanguage(String lang) {
        super.applyAnnotationLanguage(lang);
        XpAnnotationGenerator ag = this.getAnnotationGenerator();
        if (ag instanceof XpApdAnnotationGenerator) {
            XpApdAnnotationGenerator generator = (XpApdAnnotationGenerator)ag;
            generator.setLanguage(lang);
        }
    }

    public String[] getAnnotationGroups() {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            return am.getAnnotationGroups();
        }
        return null;
    }

    public String[] getAnnotationItems() {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            return am.getAnnotationItems();
        }
        return null;
    }

    public String[] getAnnotationItems(String agName) {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            return am.getAnnotationItems(agName);
        }
        return null;
    }

    public void setAnnotationGroup(String agName, boolean activate) {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            am.setAnnotationGroup(agName, activate);
        }
    }

    public void setAnnotationItems(String[] annoItems, boolean activate) {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            am.setAnnotationItems(annoItems, activate);
        }
    }

    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            am.queryAnnotationItems(annoItems, queryRes);
        }
    }

    public boolean queryAnnotationItem(String aiName) {
        XpAnnotationModel am = this.annotVc.getAnnotationModel();
        if (am != null) {
            return am.queryAnnotationItem(aiName);
        }
        return false;
    }

    public void setAnnotationVisible(boolean annotVisible) {
        this.annotVc.setVisible(annotVisible);
    }

    public boolean isAnnotationVisible() {
        return this.annotVc.isVisible();
    }

    public void setAnnotationColor(Color c) {
        this.annotVc.setForeground(c);
    }

    public Color getAnnotationColor() {
        return this.annotVc.getForeground();
    }

    public void setColorMap(int[] cMap) {
        this.tc.setColorMap(cMap);
    }

    public int[] getColorMap() {
        return this.tc.getColorMap();
    }

    public int addFragmentProgram(XjFragmentProgram fp) {
        return this.tc.addFragmentProgram(fp);
    }

    public int removeFragmentProgram(XjFragmentProgram fp) {
        return this.tc.removeFragmentProgram(fp);
    }

    public int getNumFragmentPrograms() {
        return this.tc.getNumFragmentPrograms();
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public void setSelected(boolean selection) {
        boolean old = this.selected_;
        this.selected_ = selection;
    }

    public void componentAddedNotification(ComponentCapable cc) {
    }

    public void componentCreationNotification(ComponentCapable cc) {
        if (this.componentCreator != null) {
            this.componentCreator.removeViewport(this, this.getT3DComponent());
            this.componentCreator.removeComponentCreationListener(this);
            this.componentCreator = null;
        }
        this.getT3DComponent().setCursor(this.oldCursor);
        this.enableMouseController();
        List roiList = this.getRois();
        int numberOfRois = roiList.size();
        for (int i = 0; i < numberOfRois; ++i) {
            RoiActor ra;
            Xp3DRoiVc vc = (Xp3DRoiVc)this.rois.get(roiList.get(i));
            if (vc == null || !vc.isVisible() || (ra = vc.getRoiActor()) == null || !ra.isSelected()) continue;
            vc.requestFocus();
        }
    }

    protected Map getRoiMap() {
        return this.rois;
    }

    protected Map getUserAnnotationMap() {
        return this.uannos;
    }

    protected List getRoiList() {
        return this.roilist;
    }

    protected List getUserAnnotationList() {
        return this.uannolist;
    }

    public static class T3DAnnotationGenerator
    extends XpApdAnnotationGenerator {
        private Vector amvector = new Vector();

        public XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
            T3DAnnotation annot = new T3DAnnotation(dobj, aps);
            this.amvector.add(annot);
            return annot;
        }

        public void reset() {
            int len = this.amvector.size();
            for (int i = 0; i < len; ++i) {
                T3DAnnotation annot = (T3DAnnotation)this.amvector.get(i);
                annot.dispose();
            }
            this.amvector.clear();
            super.reset();
        }
    }

    private static class T3DAnnotation
    extends XpApdAnnotation {
        public T3DAnnotation(XpDicomObject mi, ApStyle apStyle) {
            super(mi, apStyle);
        }

        public XpAnnotationConfig getAnnotationConfig(Class apStyleClass) {
            XpDicomElement modElement = new XpDicomElement(8, 96);
            XpDicomObject mi = this.getDicomObject();
            int result = mi.getValue(modElement);
            String modality = (String)modElement.value;
            if (modality.equals("PT")) {
                return new XpMRCTApdAnnotationConfig.PETFull();
            }
            return new T3DAnnotConfig();
        }
    }

    public static class T3DAnnotConfig
    extends XpMRCTApdAnnotationConfig {
        private Dimension size = new Dimension();
        private XpRASAnnotation rasAnno = new XpRASAnnotation();
        private double[] up = new double[3];
        private double[] lookpt = new double[3];
        private double[] eyept = new double[3];
        private CPoint[] cornerPts = new CPoint[3];
        private JnVector3d u = new JnVector3d();
        private JnVector3d r = new JnVector3d();
        private JnVector3d v = new JnVector3d();

        public T3DAnnotConfig() {
            for (int i = 0; i < this.cornerPts.length; ++i) {
                this.cornerPts[i] = new CPoint(2);
            }
        }

        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            T3DComponent tc = (T3DComponent)jc;
            if (am == null) {
                return;
            }
            this.setT3DRASCorners(avc, tc);
            this.setRenderAttributes(avc, tc);
            this.setROIInfo(avc, tc);
        }

        private void calc_cam(double[] eyepoint, double[] lookpoint, double[] up) {
            this.v.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
            this.v.normalize();
            this.u.set(-up[0], -up[1], -up[2]);
            this.u.normalize();
            JnVector3d.cross(this.u, this.v, this.r);
            this.r.normalize();
            JnVector3d.cross(this.v, this.r, this.u);
            this.u.normalize();
        }

        private void setT3DRASCorners(XpAnnotationVc avc, T3DComponent tc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            String rasSouth = null;
            String rasNorth = null;
            String rasEast = null;
            String rasWest = null;
            tc.getSize(this.size);
            int w = this.size.width;
            int h = this.size.height;
            int hw = w >> 1;
            int hh = h >> 1;
            double viewHeight = tc.getViewHeight();
            double aspectRatio = tc.getAspectRatio();
            double viewWidth = viewHeight * aspectRatio;
            double spX = viewWidth / (double)w;
            double spY = viewHeight / (double)h;
            tc.getEyePoint(this.eyept);
            tc.getLookPoint(this.lookpt);
            tc.getUp(this.up);
            double len = Math.sqrt(this.up[0] * this.up[0] + this.up[1] * this.up[1] + this.up[2] * this.up[2]);
            this.up[0] = this.up[0] / len;
            this.up[1] = this.up[1] / len;
            this.up[2] = this.up[2] / len;
            this.calc_cam(this.eyept, this.lookpt, this.up);
            this.cornerPts[0].x = this.lookpt[0] + this.up[0] * spY * (double)hh - this.r.x * spX * (double)hw;
            this.cornerPts[0].y = this.lookpt[1] + this.up[1] * spY * (double)hh - this.r.y * spX * (double)hw;
            this.cornerPts[0].z = this.lookpt[2] + this.up[2] * spY * (double)hh - this.r.z * spX * (double)hw;
            this.cornerPts[1].x = this.lookpt[0] + this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
            this.cornerPts[1].y = this.lookpt[1] + this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
            this.cornerPts[1].z = this.lookpt[2] + this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
            this.cornerPts[2].x = this.lookpt[0] - this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
            this.cornerPts[2].y = this.lookpt[1] - this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
            this.cornerPts[2].z = this.lookpt[2] - this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
            this.rasAnno.set(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
            rasNorth = this.rasAnno.getNorth();
            rasSouth = this.rasAnno.getSouth();
            rasEast = this.rasAnno.getEast();
            rasWest = this.rasAnno.getWest();
            am.setProperty("rasSouth", rasSouth);
            am.setProperty("rasNorth", rasNorth);
            am.setProperty("rasEast", rasEast);
            am.setProperty("rasWest", rasWest);
        }
    }

    private class DicomSource
    implements XpDicomObject {
        private XjDicomObject dobj = null;
        private double[] clip = new double[2];
        private double curr_thickness = -1.0;

        public DicomSource(XjDicomObject dobj) {
            this.dobj = dobj;
        }

        public int getValues(XpDicomElement[] values) {
            int notLoaded = 0;
            for (int i = 0; i < values.length; ++i) {
                int result = this.getValue(values[i]);
                if (result != 1) continue;
                ++notLoaded;
            }
            return notLoaded;
        }

        public int getValue(XpDicomElement value) {
            if (value.group == 24 && value.element == 80) {
                XpAnnotationModel am;
                T3DViewport.this.getViewClip(this.clip);
                double thickness = Math.abs(this.clip[0]) + Math.abs(this.clip[1]);
                if (thickness > 0.0) {
                    value.value = "" + thickness;
                } else {
                    Object val = this.dobj.getValue(value.group, value.element);
                    thickness = Double.parseDouble("" + val);
                    if (val != null) {
                        value.value = val;
                    }
                }
                if (this.curr_thickness != thickness && (am = T3DViewport.this.annotVc.getAnnotationModel()) instanceof XpApdAnnotation) {
                    ((XpApdAnnotation)am).getApStyle().reset();
                }
                this.curr_thickness = thickness;
                return 0;
            }
            Object val = this.dobj.getValue(value.group, value.element);
            if (val != null) {
                value.value = val;
                return 0;
            }
            return 1;
        }
    }
}

