/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpGeomUtils;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class NearestNeighbor {
    private static final int SHIFT = 12;
    private static final int SCALE = 4096;
    private static final int MASK = 4095;
    private static XpGeomUtils gu = new XpGeomUtils();
    private Point2D iul = new Point2D.Double();
    private Point2D ibl = new Point2D.Double();
    private Point2D iur = new Point2D.Double();
    private Point2D ibr = new Point2D.Double();

    public final void doINNShortToShort(double[] tx, double[] itx, short[] input, int ioffset, int iw, int ih, short[] output, int ow, int oh, short background) {
        long t1 = System.currentTimeMillis();
        int m00 = (int)(itx[0] * 4096.0);
        int m10 = (int)(itx[1] * 4096.0);
        int m01 = (int)(itx[2] * 4096.0);
        int m11 = (int)(itx[3] * 4096.0);
        int m02 = (int)(itx[4] * 4096.0);
        int m12 = (int)(itx[5] * 4096.0);
        this.iul.setLocation(2.0, 2.0);
        this.ibl.setLocation(2.0, ih - 2);
        this.iur.setLocation(iw - 2, 2.0);
        this.ibr.setLocation(iw - 2, ih - 2);
        double xxul = tx[0] * this.iul.getX() + tx[2] * this.iul.getY() + tx[4];
        double yyul = tx[1] * this.iul.getX() + tx[3] * this.iul.getY() + tx[5];
        int x1 = (int)xxul;
        int y1 = (int)yyul;
        int x2 = (int)xxul;
        int y2 = (int)yyul;
        double xxbl = tx[0] * this.ibl.getX() + tx[2] * this.ibl.getY() + tx[4];
        double yybl = tx[1] * this.ibl.getX() + tx[3] * this.ibl.getY() + tx[5];
        x1 = Math.min(x1, (int)xxbl);
        x2 = Math.max(x2, (int)xxbl);
        y1 = Math.min(y1, (int)yybl);
        y2 = Math.max(y2, (int)yybl);
        double xxur = tx[0] * this.iur.getX() + tx[2] * this.iur.getY() + tx[4];
        double yyur = tx[1] * this.iur.getX() + tx[3] * this.iur.getY() + tx[5];
        x1 = Math.min(x1, (int)xxur);
        x2 = Math.max(x2, (int)xxur);
        y1 = Math.min(y1, (int)yyur);
        y2 = Math.max(y2, (int)yyur);
        double xxbr = tx[0] * this.ibr.getX() + tx[2] * this.ibr.getY() + tx[4];
        double yybr = tx[1] * this.ibr.getX() + tx[3] * this.ibr.getY() + tx[5];
        x1 = Math.min(x1, (int)xxbr);
        x2 = Math.max(x2, (int)xxbr);
        y1 = Math.min(y1, (int)yybr);
        y2 = Math.max(y2, (int)yybr);
        x1 = Math.max(x1, 0);
        x2 = Math.min(x2, ow - 1);
        y1 = Math.max(y1, 0);
        y2 = Math.min(y2, oh - 1);
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (int y = y1; y < y2; ++y) {
            int offset = y * ow;
            int tr_1 = m01 * y + m02;
            int tr_2 = m11 * y + m12;
            for (int x = x1; x < x2; ++x) {
                int tx_x = m00 * x + tr_1;
                int tx_y = m10 * x + tr_2;
                int xc = tx_x >> 12;
                int yc = tx_y >> 12;
                if (xc < 0 || xc >= iw || yc < 0 || yc >= ih) continue;
                int pIdx = ioffset + yc * iw + xc;
                output[offset + x] = input[pIdx];
            }
        }
    }
}

