/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.image.XpImage2DModel;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpOffscreenRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class XpImage2DRenderer
extends ComponentUI {
    public final double ZOOM_NUDGE = 1.000000000001;
    public final double INV_NUDGE = 0.9999999999989999;
    private static final String noImageMessage;
    private static final String emptyFontName;
    private static final int emptyFontSize;
    private static final Font emptyMsgFont;
    public static boolean needClipNudge;
    public static final int WWWL_STAGE = 0;
    private static int renderIdPool;
    private static XpDrawableFactory defaultFactory;
    private static double DPINCH;
    private boolean transformDirty = true;
    private boolean pixelTransferDirty = true;
    private Rectangle lastViewport = new Rectangle();
    private boolean _didTransformOp = false;
    private XpImage2DModel model = new XpImage2DModel();
    private Shape clipShape = null;
    private Shape imageClipShape = null;
    private Object interpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private XpImage image = null;
    private XpGeomUtils gu = new XpGeomUtils();
    private List currentOpList = new ArrayList();
    private BufferedImage opImg1 = null;
    private BufferedImage opImg2 = null;
    private XpDrawableFactory drwFactory = defaultFactory;
    private boolean wwwlStage = true;
    private boolean fitToViewport = true;
    private int rendererId = 0;
    private double azimuth = 0.0;
    private int bitsAllocated = 0;
    private int bitsStored = 0;
    private int pixelRepresentation = 1;
    private int pixelPaddingValue = 0;
    private long lastRenderTimeStamp = 0L;
    private Rectangle viewport = new Rectangle();
    private boolean pixelsLoaded = false;
    private PixelWindowing pixwin = new PixelWindowing();
    private Component component = null;
    private int imageLayer = 0;
    private int[][] img_layers = null;
    private XjFusionPixelCombiner fpc = null;
    private Point2D[] ptsClippedArea = new Point2D[4];
    private Point2D[] ptsImgBorder = new Point2D[4];
    public static boolean removeSawtooth;
    private double[] dPtCoords = new double[6];
    private Stroke STROKE_OUTER = new BasicStroke(2.0f);
    private CPoint cpImg1 = new CPoint(1);
    private CPoint cpImg2 = new CPoint(1);
    private CPoint cpImg3 = new CPoint(1);
    private CPoint cpImg4 = new CPoint(1);
    private CPoint cpImg = new CPoint(0);
    private XpDicomElement[] pixvalues = new XpDicomElement[]{new XpDicomElement(40, 256), new XpDicomElement(40, 257), new XpDicomElement(40, 259), new XpDicomElement(40, 288)};
    private AffineTransform inv_tx = new AffineTransform();
    private Shape saveClip = null;
    private CPoint ras_pt = new CPoint(2);
    private CPoint tempImg = new CPoint(0);

    public XpImage2DRenderer() {
        this.rendererId = renderIdPool++;
        for (int i = 0; i < this.ptsClippedArea.length; ++i) {
            this.ptsClippedArea[i] = new Point2D.Double();
            this.ptsImgBorder[i] = new Point2D.Double();
        }
    }

    public final int getRendererId() {
        return this.rendererId;
    }

    public final Color getBackground() {
        if (this.component != null) {
            return this.component.getBackground();
        }
        return Color.black;
    }

    public void dispose() {
    }

    public final void configPipeline(int pipelineStage, boolean execute) {
        switch (pipelineStage) {
            case 0: {
                this.wwwlStage = execute;
            }
        }
    }

    public final boolean isClip() {
        Shape iraImageClipShape = null;
        Shape iraClipShape = null;
        if (this.model.attributes != null) {
            iraImageClipShape = this.model.attributes.getImageClip();
            iraClipShape = this.model.attributes.getClipShape();
        }
        return this.imageClipShape != null || iraImageClipShape != null || this.clipShape != null || iraClipShape != null;
    }

    public final void applyClip(Graphics2D g2) {
        this.saveClip = g2.getClip();
        Shape iraImageClipShape = null;
        Shape iraClipShape = null;
        if (this.model.attributes != null) {
            iraImageClipShape = this.model.attributes.getImageClip();
            iraClipShape = this.model.attributes.getClipShape();
        }
        if (this.imageClipShape != null || iraImageClipShape != null) {
            AffineTransform tx = this.getAffineTransform();
            this.gu.calcInverse(tx, this.inv_tx);
            g2.transform(tx);
            if (this.imageClipShape != null) {
                g2.clip(this.imageClipShape);
            }
            if (iraImageClipShape != null) {
                g2.clip(iraImageClipShape);
            }
            g2.transform(this.inv_tx);
        }
        if (this.clipShape != null) {
            g2.clip(this.clipShape);
        }
        if (iraClipShape != null) {
            g2.clip(iraClipShape);
        }
        if (needClipNudge && (this.clipShape != null || this.imageClipShape != null || iraImageClipShape != null || iraClipShape != null)) {
            g2.scale(1.000000000001, 1.000000000001);
        }
    }

    private void calcClipPoints(Point2D[] ptsClippedArea) {
        AffineTransform tx = this.getAffineTransform();
        PathIterator pIter = this.imageClipShape.getPathIterator(tx);
        int iCounter = 0;
        while (!pIter.isDone()) {
            int iSegmentType = pIter.currentSegment(this.dPtCoords);
            switch (iSegmentType) {
                case 0: {
                    ptsClippedArea[iCounter].setLocation(this.dPtCoords[0], this.dPtCoords[1]);
                    ++iCounter;
                    break;
                }
                case 1: {
                    ptsClippedArea[iCounter].setLocation(this.dPtCoords[0], this.dPtCoords[1]);
                    ++iCounter;
                    break;
                }
            }
            pIter.next();
        }
    }

    private void drawBorders(Graphics2D g2) {
        g2.setColor(Color.black);
        g2.setStroke(this.STROKE_OUTER);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double l = new Line2D.Double();
        for (int i = 0; i < this.ptsImgBorder.length; ++i) {
            if (this.isClip()) {
                ((Line2D)l).setLine(this.ptsClippedArea[i].getX(), this.ptsClippedArea[i].getY(), this.ptsClippedArea[(i + 1) % this.ptsClippedArea.length].getX(), this.ptsClippedArea[(i + 1) % this.ptsClippedArea.length].getY());
                g2.draw(l);
            }
            ((Line2D)l).setLine(this.ptsImgBorder[i].getX(), this.ptsImgBorder[i].getY(), this.ptsImgBorder[(i + 1) % this.ptsImgBorder.length].getX(), this.ptsImgBorder[(i + 1) % this.ptsImgBorder.length].getY());
            g2.draw(l);
        }
    }

    private void calcImageBorder(Point2D[] ptsImgBorder) {
        double x1 = this.getImage().getMinX();
        double x2 = this.getImage().getMinX() + this.getImage().getWidth();
        double y1 = this.getImage().getMinY();
        double y2 = this.getImage().getMinY() + this.getImage().getHeight();
        this.cpImg1.x = x1;
        this.cpImg1.y = y1;
        this.cpImg2.x = x2;
        this.cpImg2.y = y1;
        this.cpImg3.x = x2;
        this.cpImg3.y = y2;
        this.cpImg4.x = x1;
        this.cpImg4.y = y2;
        this.getTransform().transform(this.cpImg1, this.cpImg);
        ptsImgBorder[0].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg2, this.cpImg);
        ptsImgBorder[1].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg3, this.cpImg);
        ptsImgBorder[2].setLocation(this.cpImg.x, this.cpImg.y);
        this.getTransform().transform(this.cpImg4, this.cpImg);
        ptsImgBorder[3].setLocation(this.cpImg.x, this.cpImg.y);
    }

    public final void clearClip(Graphics2D g2) {
        if (this.isClip()) {
            g2.setClip(this.saveClip);
            if (needClipNudge) {
                g2.scale(0.9999999999989999, 0.9999999999989999);
            }
        }
    }

    protected void setChangeRender() {
    }

    public final void renderImage(Graphics graphics, Rectangle viewport) {
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.getImage() != null) {
            this.computeTransform(viewport);
            if (this.isClip()) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, viewport.width, viewport.height);
            }
            this.applyClip(g2);
            this.render(g2, viewport);
            if (removeSawtooth) {
                if (this.isClip()) {
                    this.calcClipPoints(this.ptsClippedArea);
                }
                this.calcImageBorder(this.ptsImgBorder);
                this.drawBorders(g2);
            }
            this.clearClip(g2);
            this.lastRenderTimeStamp = System.currentTimeMillis();
        }
    }

    public abstract void render(Graphics var1, Rectangle var2);

    public final void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.model.attributes = attr;
        this.transformDirty = true;
        this.newImageRenderAttributesCB(attr);
        if (!this.sameList(this.currentOpList, attr.getImageOperations())) {
            this.assignList(this.currentOpList, attr.getImageOperations());
            this.loadPixelData();
        }
    }

    public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
    }

    public final XpImageRenderAttributes getImageRenderAttributes() {
        return this.model.attributes;
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        if (layer == 0) {
            return this.model.attributes.getImagePixelAttributes();
        }
        int len = this.model.imgLayers.size();
        if (layer <= len) {
            XpImageLayer il = (XpImageLayer)this.model.imgLayers.get(layer - 1);
            return il.getImagePixelAttributes();
        }
        return null;
    }

    public void refreshImageRenderAttributes() {
        this.pixelTransferDirty = true;
        this.setImageRenderAttributes(this.model.attributes);
    }

    public void refreshImage() {
        this.loadXpImage(this.image);
    }

    public final long getRenderTimeStamp() {
        return this.lastRenderTimeStamp;
    }

    private void loadPixelData() {
        XpImage theImage = this.image;
        if (theImage != null) {
            RenderedImage ri = theImage.getPixelData();
            ColorModel cm = ri.getColorModel();
            this.pixwin.loadColorOverrides(cm);
            this.transformDirty = true;
            this.pixelsLoaded = true;
            RenderedImage opImage = this.doImageOperations(ri);
            this.newImageCB(opImage);
        }
    }

    protected void cleanImage() {
    }

    private void loadXpImage(XpImage img) {
        if (img != null) {
            int oldW = -99;
            int oldH = -99;
            XpImage theImage = this.image;
            if (theImage != null) {
                XpSlice s = theImage.getSlice();
                oldW = s.width;
                oldH = s.height;
            }
            XpSlice newSl = img.getSlice();
            if (oldW != newSl.width || oldH != newSl.height) {
                this.transformDirty = true;
            }
            this.azimuth = img.getAzimuth();
            this.model.width = newSl.width;
            this.model.height = newSl.height;
            boolean loadBitsAlloc = false;
            boolean loadBitsStored = false;
            boolean loadPixelRep = false;
            boolean loadPixelPadding = false;
            if (img instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)img);
                loadBitsAlloc = dobj.getValue(this.pixvalues[0]) == 0;
                loadBitsStored = dobj.getValue(this.pixvalues[1]) == 0;
                loadPixelRep = dobj.getValue(this.pixvalues[2]) == 0;
                boolean bl = loadPixelPadding = dobj.getValue(this.pixvalues[3]) == 0;
                if (loadBitsAlloc) {
                    String bits_alloc = "" + this.pixvalues[0].value;
                    try {
                        this.bitsAllocated = Integer.parseInt(bits_alloc);
                        if (this.bitsAllocated <= 0) {
                            loadBitsAlloc = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsAlloc = false;
                    }
                }
                if (loadBitsStored) {
                    String bits_stored = "" + this.pixvalues[1].value;
                    try {
                        this.bitsStored = Integer.parseInt(bits_stored);
                        if (this.bitsStored <= 0) {
                            loadBitsStored = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsStored = false;
                    }
                }
                if (loadPixelRep) {
                    try {
                        this.pixelRepresentation = Integer.parseInt("" + this.pixvalues[2].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelRep = false;
                    }
                }
                if (loadPixelPadding) {
                    try {
                        this.pixelPaddingValue = Integer.parseInt("" + this.pixvalues[3].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelPadding = false;
                    }
                }
            }
            if (!loadBitsAlloc) {
                this.bitsAllocated = -1;
            }
            if (!loadBitsStored) {
                this.bitsStored = -1;
            }
            if (!loadPixelRep) {
                this.pixelRepresentation = 1;
            }
            if (!loadPixelPadding) {
                this.pixelPaddingValue = -2000;
            }
        } else {
            this.cleanImage();
        }
        this.image = img;
        this.pixelsLoaded = false;
        List layers = this.model.imgLayers;
        if (layers != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                XpOffscreenRenderer offscreen = il.getOffscreenRenderer();
                if (offscreen == null) continue;
                offscreen.refresh();
            }
        }
    }

    public final double getAzimuth() {
        return this.azimuth;
    }

    public final double getRescaleSlope() {
        if (this.image != null) {
            return this.image.getRescaleSlope();
        }
        return 1.0;
    }

    public final double getRescaleIntercept() {
        if (this.image != null) {
            return this.image.getRescaleIntercept();
        }
        return 0.0;
    }

    public final void setImage(XpImage image) {
        if (image == this.image) {
            return;
        }
        this.loadXpImage(image);
    }

    public final List getImageLayers() {
        return this.model.imgLayers;
    }

    public int getNumImageLayers() {
        if (this.model.imgLayers != null) {
            return this.model.imgLayers.size() + 1;
        }
        return 1;
    }

    public final void setImageLayers(List imgLayers) {
        this.model.imgLayers = imgLayers;
    }

    protected boolean renderImageLayers() {
        boolean toFuse = false;
        List layers = this.model.imgLayers;
        if (layers != null && this.image != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                int[] outbuffer = null;
                if (il.frame == null) continue;
                XpOffscreenRenderer offscreen = il.getOffscreenRenderer();
                if (offscreen == null) {
                    int iw = this.model.width;
                    int ih = this.model.height;
                    XpSlice baseSlice = this.image.getSlice();
                    il.resizeOffscreenRenderer(iw, ih);
                    offscreen = il.getOffscreenRenderer();
                    XpImage img = il.frame;
                    XpSlice slice = img.getSlice();
                    CPoint bI = new CPoint(baseSlice.I);
                    CPoint bJ = new CPoint(baseSlice.J);
                    CPoint I = new CPoint(slice.I);
                    CPoint J = new CPoint(slice.J);
                    bI.scale(baseSlice.pixelSizeX * 0.5);
                    bJ.scale(baseSlice.pixelSizeY * 0.5);
                    I.scale(slice.pixelSizeX * 0.5);
                    J.scale(slice.pixelSizeY * 0.5);
                    bI.sub(I);
                    bJ.sub(J);
                    CTransform img2ras = (CTransform)baseSlice.getImageToRasTransform().clone();
                    img2ras.m[3] = img2ras.m[3] + (bI.x + bJ.x);
                    img2ras.m[7] = img2ras.m[7] + (bI.y + bJ.y);
                    img2ras.m[11] = img2ras.m[11] + (bI.z + bJ.z);
                    CTransform txRAS2Image = img2ras.inverse();
                    this.ras_pt.scaleAdd(-slice.pixelSizeX * 0.5, slice.I, slice.ul);
                    this.ras_pt.scaleAdd(-slice.pixelSizeY * 0.5, slice.J, this.ras_pt);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double ul = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    this.ras_pt.scaleAdd((double)slice.width * slice.pixelSizeX, slice.I);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double ur = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    this.ras_pt.scaleAdd((double)slice.height * slice.pixelSizeY, slice.J);
                    txRAS2Image.transform(this.ras_pt, this.tempImg);
                    Point2D.Double br = new Point2D.Double(this.tempImg.x, this.tempImg.y);
                    offscreen.setImage(img, ul, ur, br);
                    il.loadImagePixelAttributes();
                } else if (this.isPixelTransferDirty()) {
                    il.loadImagePixelAttributes();
                }
                offscreen.render(this.getInterpolationHint());
                outbuffer = offscreen.getRaster();
                toFuse = true;
            }
        }
        this.setPixelTransferDirty(false);
        return toFuse;
    }

    public boolean isImageLayerRenderChange() {
        List layers = this.model.imgLayers;
        if (layers != null) {
            int len = layers.size();
            for (int i = 0; i < len; ++i) {
                XpImageLayer il = (XpImageLayer)layers.get(i);
                XpOffscreenRenderer or = il.getOffscreenRenderer();
                if (or == null || !or.isPixelTransfer()) continue;
                return true;
            }
        }
        return false;
    }

    public final void blendImageLayers(BufferedImage bimg, int[] output) {
        List layers = this.model.imgLayers;
        if (this.fpc != null && layers != null) {
            boolean toFuse = this.renderImageLayers();
            int len = layers.size();
            int nlayers = len + 1;
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            if (this.img_layers == null || this.img_layers.length != nlayers) {
                this.img_layers = new int[nlayers][];
            }
            for (int i = 0; i < len; ++i) {
                XpOffscreenRenderer offscreen;
                XpImageLayer il = (XpImageLayer)layers.get(i);
                if (il.frame == null || (offscreen = il.getOffscreenRenderer()) == null) continue;
                this.img_layers[i + 1] = offscreen.getRaster();
            }
            DataBuffer db = bimg.getRaster().getDataBuffer();
            if (db instanceof DataBufferInt) {
                this.img_layers[0] = ((DataBufferInt)db).getData();
                if (toFuse) {
                    this.fpc.blendRGB(this.img_layers, width, height, output);
                } else {
                    System.arraycopy(this.img_layers[0], 0, output, 0, output.length);
                }
            }
        }
    }

    public final XpImage getFrame() {
        return this.image;
    }

    public final void setImage(RenderedImage image) {
        this.model.width = image.getWidth();
        this.model.height = image.getHeight();
        this.transformDirty = true;
        this.azimuth = 0.0;
        RenderedImage opImage = this.doImageOperations(image);
        this.newImageCB(opImage);
    }

    public abstract void newImageCB(RenderedImage var1);

    private RenderedImage doImageOperations(RenderedImage inputImage) {
        int w = inputImage.getWidth();
        int h = inputImage.getHeight();
        int opListLen = this.currentOpList.size();
        if (opListLen > 0) {
            int oph;
            int opw;
            boolean createOpImage = false;
            if (this.opImg1 != null) {
                opw = this.opImg1.getWidth();
                oph = this.opImg1.getHeight();
                if (opw != w || oph != h) {
                    createOpImage = true;
                }
            } else {
                createOpImage = true;
            }
            if (createOpImage) {
                this.opImg1 = XpImageData.createCompatibleBufferedImage(inputImage);
            }
            if (opListLen > 1) {
                createOpImage = false;
                if (this.opImg2 != null) {
                    opw = this.opImg2.getWidth();
                    oph = this.opImg2.getHeight();
                    if (opw != w || oph != h) {
                        createOpImage = true;
                    }
                } else {
                    createOpImage = true;
                }
                if (createOpImage) {
                    this.opImg2 = XpImageData.createCompatibleBufferedImage(inputImage);
                }
            }
            RenderedImage input = inputImage;
            RenderedImage output = this.opImg1;
            RenderedImage result = input;
            for (int i = 0; i < opListLen; ++i) {
                XpImageOp iop = (XpImageOp)this.currentOpList.get(i);
                if (iop == null) continue;
                iop.execute(input, output);
                result = output;
                if (i == 0) {
                    input = this.opImg1;
                    output = this.opImg2;
                    continue;
                }
                RenderedImage tmp = input;
                input = output;
                output = tmp;
            }
            return result;
        }
        return inputImage;
    }

    private boolean sameList(List l1, List l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        int len = l1.size();
        for (int i = 0; i < len; ++i) {
            Object o2;
            Object o1 = l1.get(i);
            if (o1 == (o2 = l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void assignList(List l1, List l2) {
        l1.clear();
        int len = l2.size();
        for (int i = 0; i < len; ++i) {
            Object o = l2.get(i);
            l1.add(o);
        }
    }

    public final RenderedImage getImage() {
        RenderedImage rimg = null;
        XpImage theImage = this.image;
        if (theImage != null) {
            rimg = theImage.getPixelData();
        }
        return rimg;
    }

    public CTransform getTransform() {
        return this.model.transform;
    }

    public final XpImageOrientation getDisplayOrientation() {
        XpImage theImage = this.image;
        if (theImage != null) {
            double angle = theImage.getAzimuth();
            if (angle != 0.0) {
                XpImageOrientation ior = this.gu.getEffectiveRotation(angle);
                XpImageOrientation ori = this.model.attributes.getImageOrientation();
                ior.apply(ori);
                return ior;
            }
            return this.model.attributes.getImageOrientation();
        }
        return null;
    }

    protected final boolean didTransformOp() {
        return this._didTransformOp;
    }

    protected void calcAffineTransform(Component component, Rectangle viewport, XpImage image, int w, int h, XpImageRenderAttributes ira, AffineTransform tx) {
        int psmode = ira.getPresentationSizeMode();
        double px = image.getPixelDimensionX();
        double py = image.getPixelDimensionY();
        if (psmode == 101 && component != null) {
            double dpinch = DPINCH > 0.0 ? DPINCH : (double)component.getToolkit().getScreenResolution();
            double dpmm = dpinch / XpGeomUtils.MM_PER_INCH;
            this.gu.calcAffineTransform(viewport, ira, w, h, this.azimuth, this.fitToViewport, dpmm, px, py, this.model.tx);
        } else {
            this.gu.calcAffineTransform(viewport, ira, w, h, this.azimuth, this.fitToViewport, px, py, this.model.tx);
        }
    }

    private void computeTransform(Rectangle viewport) {
        this._didTransformOp = false;
        if (this.transformDirty || !viewport.equals(this.lastViewport)) {
            this._didTransformOp = true;
            int w = this.model.width;
            int h = this.model.height;
            XpImageRenderAttributes ira = this.model.attributes;
            this.calcAffineTransform(this.component, viewport, this.image, w, h, ira, this.model.tx);
            this.model.transform.load(this.model.tx);
            this.transformDirty = false;
            this.lastViewport.setBounds(viewport);
        }
    }

    public final AffineTransform getTransform2D() {
        this.getTransform();
        AffineTransform at = this.getAffineTransform();
        return (AffineTransform)at.clone();
    }

    public final XpImageRenderAttributes getAttributes() {
        return this.model.attributes;
    }

    public AffineTransform getAffineTransform() {
        return this.model.tx;
    }

    public final int getWidth() {
        return this.model.width;
    }

    public final int getHeight() {
        return this.model.height;
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb) {
        if (!this.wwwlStage) {
            return;
        }
        this.pixwin.fillColorTable(attr, rgb, this.getRescaleSlope(), this.getRescaleIntercept(), this.getPixelRepresentation());
    }

    private void paintEmptyMessage(Graphics g, Component c) {
        if (noImageMessage != null) {
            g.setColor(Color.WHITE);
            g.setFont(emptyMsgFont);
            FontMetrics fntMetrics = g.getFontMetrics();
            int iStrWidth = fntMetrics.stringWidth(noImageMessage);
            int iStartPos = c.getSize().width / 2 - iStrWidth / 2;
            if (iStartPos < 1) {
                iStartPos = 1;
            }
            g.drawString(noImageMessage, iStartPos, c.getSize().height / 2);
        }
    }

    public final void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.component = c;
        this.paintAWT(g, c);
    }

    public void paintAWT(Graphics g, Component c) {
        c.getBounds(this.viewport);
        if (this.image == null) {
            g.setColor(c.getBackground());
            g.fillRect(this.viewport.x, this.viewport.y, this.viewport.width, this.viewport.height);
            this.paintEmptyMessage(g, c);
        } else {
            if (!this.pixelsLoaded) {
                this.loadPixelData();
            }
            if (this.pixelsLoaded) {
                this.renderImage(g, this.viewport);
            }
        }
    }

    public static ComponentUI createUI(JComponent c) {
        ComponentUI cui = (ComponentUI)XpPropertiesManager.create("com.ge.med.terra.jami.render.XpJImage2DRenderer");
        return cui;
    }

    public final void setImageClip(Shape s) {
        this.imageClipShape = s;
        this.setChangeRender();
    }

    public final Shape getImageClip() {
        return this.imageClipShape;
    }

    public Shape getClipShape() {
        return this.clipShape;
    }

    public void setClipShape(Shape clipShape) {
        this.clipShape = clipShape;
        this.setChangeRender();
    }

    public final Object getInterpolationHint() {
        return this.interpolationHint;
    }

    public final void setInterpolationHint(Object interpolationHint) {
        if (this.interpolationHint != interpolationHint) {
            this.interpolationHint = interpolationHint;
            this.setChangeRender();
        }
    }

    public final void setFitToViewport(boolean fToViewport) {
        if (this.fitToViewport != fToViewport) {
            this.transformDirty = true;
            this.fitToViewport = fToViewport;
            this.newImageRenderAttributesCB(this.model.attributes);
        }
    }

    public final boolean getFitToViewport() {
        return this.fitToViewport;
    }

    protected void setPixelTransferDirty(boolean pixelTransferDirty) {
        this.pixelTransferDirty = pixelTransferDirty;
    }

    protected boolean isPixelTransferDirty() {
        return this.pixelTransferDirty;
    }

    public void selectImageLayer(int layer) {
        this.imageLayer = layer;
    }

    public int getImageLayer() {
        return this.imageLayer;
    }

    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.fpc = fpc;
    }

    public XjFusionPixelCombiner getPixelCombiner() {
        return this.fpc;
    }

    public int getBitsAllocated() {
        RenderedImage inputImage;
        if (this.bitsAllocated < 0 && (inputImage = this.getImage()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsAllocated = cc[0];
        }
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        RenderedImage inputImage;
        if (this.bitsStored < 0 && (inputImage = this.getImage()) != null) {
            int[] cc = inputImage.getColorModel().getComponentSize();
            this.bitsStored = cc[0];
        }
        return this.bitsStored;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getPixelPaddingValue() {
        return this.pixelPaddingValue;
    }

    public final void setDrawableFactory(XpDrawableFactory drwF) {
        this.drwFactory = drwF;
    }

    public final XpDrawableFactory getDrawableFactory() {
        return this.drwFactory;
    }

    public static void fillBorderLinear(double[] itx, short[] input, int ioffset, int iw, int ih, short[] output, int ow, int oh, double xvec_x, double xvec_y, int stepx, int stepy, int xstart, int ystart, int xend, int yend, int xborder0, int xborder1, int yborder0, int yborder1, int lastX, int lastY) {
        int sampleX;
        int xx;
        int yoffset;
        int sampleY;
        int yy;
        double val;
        double dy;
        double dx;
        int yc;
        int xc;
        int x;
        double pos_y;
        double pos_x;
        int offset;
        int y;
        double d00 = itx[0];
        double d10 = itx[1];
        double d01 = itx[2];
        double d11 = itx[3];
        double d02 = itx[4];
        double d12 = itx[5];
        double xdir_x = xvec_x * (double)stepx;
        double xdir_y = xvec_y * (double)stepx;
        double[][] weights = new double[2][2];
        for (y = yborder0 - stepy; y >= ystart; y -= stepy) {
            offset = y * ow;
            pos_x = d00 * (double)xstart + d01 * (double)y + d02;
            pos_y = d10 * (double)xstart + d11 * (double)y + d12;
            for (x = xstart; x < xend; x += stepx) {
                if (pos_x >= 0.0 && pos_y < (double)iw && pos_y >= 0.0 && pos_y < (double)ih) {
                    xc = (int)pos_x;
                    yc = (int)pos_y;
                    dx = pos_x - (double)xc;
                    dy = pos_y - (double)yc;
                    weights[0][0] = 1.0 - dx - dy + dx * dy;
                    weights[0][1] = dx - dx * dy;
                    weights[1][0] = dy - dx * dy;
                    weights[1][1] = dx * dy;
                    val = 0.0;
                    for (yy = 0; yy < 2; ++yy) {
                        sampleY = yc + yy;
                        if (sampleY < 0 || sampleY >= ih) continue;
                        yoffset = ioffset + sampleY * iw;
                        for (xx = 0; xx < 2; ++xx) {
                            sampleX = xc + xx;
                            if (sampleX < 0 || sampleX >= iw) continue;
                            val += (double)input[yoffset + sampleX] * weights[yy][xx];
                        }
                    }
                    output[offset + x] = (short)val;
                }
                pos_x += xdir_x;
                pos_y += xdir_y;
            }
        }
        for (y = lastY + stepy; y < yend; y += stepy) {
            offset = y * ow;
            pos_x = d00 * (double)xstart + d01 * (double)y + d02;
            pos_y = d10 * (double)xstart + d11 * (double)y + d12;
            for (x = xstart; x < xend; x += stepx) {
                if (pos_x >= 0.0 && pos_x < (double)iw && pos_y >= 0.0 && pos_y < (double)ih) {
                    xc = (int)pos_x;
                    yc = (int)pos_y;
                    dx = pos_x - (double)xc;
                    dy = pos_y - (double)yc;
                    weights[0][0] = 1.0 - dx - dy + dx * dy;
                    weights[0][1] = dx - dx * dy;
                    weights[1][0] = dy - dx * dy;
                    weights[1][1] = dx * dy;
                    val = 0.0;
                    for (yy = 0; yy < 2; ++yy) {
                        sampleY = yc + yy;
                        if (sampleY < 0 || sampleY >= ih) continue;
                        yoffset = ioffset + sampleY * iw;
                        for (xx = 0; xx < 2; ++xx) {
                            sampleX = xc + xx;
                            if (sampleX < 0 || sampleX >= iw) continue;
                            val += (double)input[yoffset + sampleX] * weights[yy][xx];
                        }
                    }
                    output[offset + x] = (short)val;
                }
                pos_x += xdir_x;
                pos_y += xdir_y;
            }
        }
        for (y = yborder0; y < yborder1; y += stepy) {
            offset = y * ow;
            int xs0 = xborder0 - stepx;
            double pos_x2 = d00 * (double)xs0 + d01 * (double)y + d02;
            double pos_y2 = d10 * (double)xs0 + d11 * (double)y + d12;
            for (int x2 = xs0; x2 >= xstart; x2 -= stepx) {
                if (pos_x2 >= 0.0 && pos_x2 < (double)iw && pos_y2 >= 0.0 && pos_y2 < (double)ih) {
                    int xc2 = (int)pos_x2;
                    int yc2 = (int)pos_y2;
                    double dx2 = pos_x2 - (double)xc2;
                    double dy2 = pos_y2 - (double)yc2;
                    weights[0][0] = 1.0 - dx2 - dy2 + dx2 * dy2;
                    weights[0][1] = dx2 - dx2 * dy2;
                    weights[1][0] = dy2 - dx2 * dy2;
                    weights[1][1] = dx2 * dy2;
                    double val2 = 0.0;
                    for (int yy2 = 0; yy2 < 2; ++yy2) {
                        int sampleY2 = yc2 + yy2;
                        if (sampleY2 < 0 || sampleY2 >= ih) continue;
                        int yoffset2 = ioffset + sampleY2 * iw;
                        for (int xx2 = 0; xx2 < 2; ++xx2) {
                            int sampleX2 = xc2 + xx2;
                            if (sampleX2 < 0 || sampleX2 >= iw) continue;
                            val2 += (double)input[yoffset2 + sampleX2] * weights[yy2][xx2];
                        }
                    }
                    output[offset + x2] = (short)val2;
                }
                pos_x2 -= xdir_x;
                pos_y2 -= xdir_y;
            }
            int xs1 = lastX + stepx;
            pos_x2 = d00 * (double)xs1 + d01 * (double)y + d02;
            pos_y2 = d10 * (double)xs1 + d11 * (double)y + d12;
            for (int x3 = xs1; x3 < xend; x3 += stepx) {
                if (pos_x2 >= 0.0 && pos_x2 < (double)iw && pos_y2 >= 0.0 && pos_y2 < (double)ih) {
                    int xc3 = (int)pos_x2;
                    int yc3 = (int)pos_y2;
                    double dx3 = pos_x2 - (double)xc3;
                    double dy3 = pos_y2 - (double)yc3;
                    weights[0][0] = 1.0 - dx3 - dy3 + dx3 * dy3;
                    weights[0][1] = dx3 - dx3 * dy3;
                    weights[1][0] = dy3 - dx3 * dy3;
                    weights[1][1] = dx3 * dy3;
                    double val3 = 0.0;
                    for (int yy3 = 0; yy3 < 2; ++yy3) {
                        int sampleY3 = yc3 + yy3;
                        if (sampleY3 < 0 || sampleY3 >= ih) continue;
                        int yoffset3 = ioffset + sampleY3 * iw;
                        for (int xx3 = 0; xx3 < 2; ++xx3) {
                            int sampleX3 = xc3 + xx3;
                            if (sampleX3 < 0 || sampleX3 >= iw) continue;
                            val3 += (double)input[yoffset3 + sampleX3] * weights[yy3][xx3];
                        }
                    }
                    output[offset + x3] = (short)val3;
                }
                pos_x2 += xdir_x;
                pos_y2 += xdir_y;
            }
        }
    }

    static {
        String sawTooth;
        String dpinch;
        noImageMessage = XpPropertiesManager.getProperty("jami.noimage.message");
        emptyFontName = XpPropertiesManager.getProperty("jami.noimage.fontname", "Monospaced");
        emptyFontSize = Integer.parseInt(XpPropertiesManager.getProperty("jami.noimage.fontsize", "16"));
        emptyMsgFont = new Font(emptyFontName, 3, emptyFontSize);
        needClipNudge = false;
        renderIdPool = 0;
        defaultFactory = new DefaultDrawableFactory();
        DPINCH = 0.0;
        removeSawtooth = false;
        String jvmVersion = XpPropertiesManager.getProperty("java.vm.version", "XXX");
        if (jvmVersion.indexOf("1.4.2") != -1) {
            XpLog.logger().info("--- MUST APPLY CLIP/ZOOM NUDGE Java Bug(4887054): " + jvmVersion);
            needClipNudge = true;
        }
        if ((dpinch = XpPropertiesManager.getProperty("jami.dotsperinch")) != null) {
            DPINCH = Double.parseDouble(dpinch);
            XpLog.logger().config("JAMI: Overriding Screen Dots/Inch with: " + DPINCH);
        }
        if ((sawTooth = XpPropertiesManager.getProperty("jami.removeSawtooth")).compareTo("true") == 0) {
            removeSawtooth = true;
        }
    }

    private static class DefaultDrawableFactory
    implements XpDrawableFactory {
        private static final int BIG_DIM = 2500;

        private DefaultDrawableFactory() {
        }

        public final XpImageDrawable createDrawable(int bpp, int w, int h) {
            XpImageDrawable.IntRGB drawable = null;
            drawable = new XpImageDrawable.IntRGB(w, h);
            return drawable;
        }

        public final int getDrawableType(int bpp, int w, int h) {
            int type = 0;
            switch (bpp) {
                case 8: {
                    type = 10;
                    break;
                }
                default: {
                    type = w > 2500 && h > 2500 ? 10 : 1;
                }
            }
            return type;
        }
    }
}

