/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpOverlayFilter;
import com.ge.med.terra.jami.render.XpPixels;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public abstract class XpImageDrawable {
    public static final String INT_RGB = "int_rgb";
    public static final String BYTE_BGR = "byte_bgr";
    public static final String LUMINANCE_BYTE = "luminance_byte";
    private static final int USHORT_MAX = 65535;
    private static final int ALPHA_MAX = 256;
    private BufferedImage bi = null;
    private int bufferedImageType = 0;
    protected byte[] overlay_bytebuff = null;
    protected short[] overlay_shortbuff = null;

    public final int getBufferedImageType() {
        return this.bufferedImageType;
    }

    protected void setBufferedImage(BufferedImage bi) {
        this.bi = bi;
        this.bufferedImageType = bi.getType();
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public int getWidth() {
        return this.bi.getWidth();
    }

    public int getHeight() {
        return this.bi.getHeight();
    }

    public void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
    }

    public void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
    }

    public void pixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
        XpColorOverlay co = ira.getColorOverlay();
        boolean doMask = false;
        if (co != null) {
            int len = co.getLength();
            if (sourcePixels.getLength() == len) {
                doMask = true;
            }
        }
        if (doMask) {
            this.maskPixelTransfer(sourcePixels, colorTable, ira);
        } else {
            this.basicPixelTransfer(sourcePixels, colorTable, ira);
        }
    }

    public static class LuminanceByte
    extends XpImageDrawable {
        private byte[] pixels = null;

        public LuminanceByte(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 10);
            this.setBufferedImage(bi);
            this.init(bi);
        }

        public LuminanceByte(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferByte dbi = (DataBufferByte)renderedRaster.getDataBuffer();
            this.pixels = dbi.getData();
        }

        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.basicPixelTransfer(sourcePixels, colorTable, ira);
        }

        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            int len = sourcePixels.getLength();
            int offset = sourcePixels.getOffset();
            int endOffset = offset + len;
            int dlen = this.pixels.length;
            int pixIdx = 0;
            byte[] bData = sourcePixels.getByteData();
            short[] sData = sourcePixels.getShortData();
            if (len != dlen) {
                return;
            }
            try {
                int didx = 0;
                if (bData != null) {
                    int i = offset;
                    while (i < endOffset) {
                        pixIdx = bData[i] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        int val = pixVal & 0xFF;
                        this.pixels[didx] = (byte)val;
                        ++i;
                        ++didx;
                    }
                } else {
                    int i = offset;
                    while (i < endOffset) {
                        pixIdx = sData[i] & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        int val = pixVal & 0xFF;
                        this.pixels[didx] = (byte)val;
                        ++i;
                        ++didx;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
            }
        }
    }

    public static class IntRGB
    extends XpImageDrawable {
        private int[] pixels = null;

        public IntRGB(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 1);
            this.setBufferedImage(bi);
            this.init(bi);
        }

        public IntRGB(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferInt dbi = (DataBufferInt)renderedRaster.getDataBuffer();
            this.pixels = dbi.getData();
        }

        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            XpColorOverlay co = ira.getColorOverlay();
            int[] cmap = co.getColorMap();
            Object clayer = co.getOverlay();
            int overlayOffset = co.getOffset();
            int overlayLength = co.getLength();
            XpOverlayFilter f = co.getOverlayFilter();
            int len = sourcePixels.getLength();
            int offset = sourcePixels.getOffset();
            int bpp = sourcePixels.getBPP();
            int mask = (1 << bpp) - 1;
            int endOffset = offset + len;
            int dlen = this.pixels.length;
            int pixIdx = 0;
            int idx = 0;
            int destIdx = 0;
            short[] sData = sourcePixels.getShortData();
            byte[] bData = sourcePixels.getByteData();
            if (len != dlen) {
                return;
            }
            try {
                if (sData != null) {
                    destIdx = 0;
                    if (clayer instanceof byte[]) {
                        byte[] overlay = (byte[])clayer;
                        if (f != null) {
                            if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlayLength) {
                                this.overlay_bytebuff = new byte[overlay.length];
                                this.overlay_shortbuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_bytebuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            idx = srcIdx;
                            int v = sData[srcIdx] & mask;
                            pixIdx = v & 0xFFFF;
                            int pixVal = colorTable[pixIdx];
                            int maskIdx = overlay[overlayIdx] & 0xFF;
                            if (maskIdx != 255) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                            }
                            this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                            ++srcIdx;
                            ++overlayIdx;
                            ++destIdx;
                        }
                    } else {
                        short[] overlay = (short[])clayer;
                        if (f != null) {
                            if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                                this.overlay_shortbuff = new short[overlay.length];
                                this.overlay_bytebuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_shortbuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            idx = srcIdx;
                            int v = sData[srcIdx] & mask;
                            pixIdx = v & 0xFFFF;
                            int pixVal = colorTable[pixIdx];
                            int maskIdx = overlay[overlayIdx] & 0xFFFF;
                            if (maskIdx != 65535) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                            }
                            this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                            ++srcIdx;
                            ++overlayIdx;
                            ++destIdx;
                        }
                    }
                } else {
                    destIdx = 0;
                    if (clayer instanceof byte[]) {
                        byte[] overlay = (byte[])clayer;
                        if (f != null) {
                            if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlay.length) {
                                this.overlay_bytebuff = new byte[overlay.length];
                                this.overlay_shortbuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_bytebuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            idx = srcIdx;
                            pixIdx = bData[srcIdx] & 0xFF;
                            int pixVal = colorTable[pixIdx];
                            byte maskIdx = overlay[overlayOffset];
                            if (maskIdx >= 0) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                            }
                            this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                            ++srcIdx;
                            ++overlayIdx;
                            ++destIdx;
                        }
                    } else {
                        short[] overlay = (short[])clayer;
                        if (f != null) {
                            if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                                this.overlay_shortbuff = new short[overlay.length];
                                this.overlay_bytebuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_shortbuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            idx = srcIdx;
                            pixIdx = bData[srcIdx] & 0xFF;
                            int pixVal = colorTable[pixIdx];
                            short maskIdx = overlay[overlayIdx];
                            if (maskIdx >= 0) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                            }
                            this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                            ++srcIdx;
                            ++overlayIdx;
                            ++destIdx;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                int dataLen = 0;
                dataLen = sData != null ? sData.length : bData.length;
                XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
                aiob.printStackTrace();
            }
        }

        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            int len = sourcePixels.getLength();
            int offset = sourcePixels.getOffset();
            int bpp = sourcePixels.getBPP();
            int mask = (1 << bpp) - 1;
            int endOffset = offset + len;
            int dlen = this.pixels.length;
            int pixIdx = 0;
            int idx = 0;
            int destIdx = 0;
            short[] sData = sourcePixels.getShortData();
            byte[] bData = sourcePixels.getByteData();
            int dtype = sourcePixels.getDataType();
            if (len != dlen) {
                return;
            }
            try {
                if (sData != null) {
                    destIdx = 0;
                    boolean signed = dtype == 1;
                    int i = offset;
                    while (i < endOffset) {
                        idx = i;
                        int v = sData[i] & mask;
                        pixIdx = v & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++i;
                        ++destIdx;
                    }
                } else {
                    destIdx = 0;
                    int i = offset;
                    while (i < endOffset) {
                        idx = i;
                        pixIdx = bData[i] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        this.pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++i;
                        ++destIdx;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                int dataLen = 0;
                dataLen = sData != null ? sData.length : bData.length;
                XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
            }
        }
    }

    public static class ByteBGR
    extends XpImageDrawable {
        private byte[] pixels = null;
        private int nPixels = 0;

        public ByteBGR(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 5);
            this.setBufferedImage(bi);
            this.init(bi);
            this.nPixels = w * h;
        }

        public ByteBGR(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferByte dbb = (DataBufferByte)renderedRaster.getDataBuffer();
            this.pixels = dbb.getData();
        }

        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            XpColorOverlay co = ira.getColorOverlay();
            int[] cmap = co.getColorMap();
            Object clayer = co.getOverlay();
            int overlayOffset = co.getOffset();
            int overlayLength = co.getLength();
            XpOverlayFilter f = co.getOverlayFilter();
            int len = sourcePixels.getLength();
            int offset = sourcePixels.getOffset();
            int bpp = sourcePixels.getBPP();
            int mask = (1 << bpp) - 1;
            int endOffset = offset + len;
            int idx = 0;
            int pixIdx = 0;
            short[] sData = sourcePixels.getShortData();
            byte[] bData = sourcePixels.getByteData();
            if (len != this.nPixels) {
                return;
            }
            try {
                if (sData != null) {
                    if (clayer instanceof byte[]) {
                        byte[] overlay = (byte[])clayer;
                        if (f != null) {
                            if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlayLength) {
                                this.overlay_bytebuff = new byte[overlayLength];
                                this.overlay_shortbuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_bytebuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            byte b2;
                            byte g;
                            byte r;
                            int v = sData[srcIdx] & mask;
                            pixIdx = v & 0xFFFF;
                            int pixVal = colorTable[pixIdx];
                            int maskIdx = overlay[overlayIdx] & 0xFF;
                            if (maskIdx != 255) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                r = (byte)(pred &= 0xFF);
                                g = (byte)(pgreen &= 0xFF);
                                b2 = (byte)(pblue &= 0xFF);
                            } else {
                                r = (byte)(pixVal >> 16 & 0xFF);
                                g = (byte)(pixVal >> 8 & 0xFF);
                                b2 = (byte)(pixVal & 0xFF);
                            }
                            this.pixels[idx] = b2;
                            this.pixels[idx + 1] = g;
                            this.pixels[idx + 2] = r;
                            idx += 3;
                            ++srcIdx;
                            ++overlayIdx;
                        }
                    } else {
                        short[] overlay = (short[])clayer;
                        if (f != null) {
                            if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                                this.overlay_shortbuff = new short[overlay.length];
                                this.overlay_bytebuff = null;
                            }
                            f.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                            overlay = this.overlay_shortbuff;
                            overlayOffset = 0;
                        }
                        int srcIdx = offset;
                        int overlayIdx = overlayOffset;
                        while (srcIdx < endOffset) {
                            byte b3;
                            byte g;
                            byte r;
                            int v = sData[srcIdx] & mask;
                            pixIdx = v & 0xFFFF;
                            int pixVal = colorTable[pixIdx];
                            int maskIdx = overlay[overlayIdx] & 0xFFFF;
                            if (maskIdx != 65535) {
                                int maskVal = cmap[maskIdx];
                                int red = (pixVal & 0xFF0000) >> 16;
                                int green = (pixVal & 0xFF00) >> 8;
                                int blue = pixVal & 0xFF;
                                int malpha = (maskVal & 0xFF000000) >> 24;
                                int mred = (maskVal & 0xFF0000) >> 16;
                                int mgreen = (maskVal & 0xFF00) >> 8;
                                int mblue = maskVal & 0xFF;
                                malpha = malpha < 0 ? 256 + malpha : malpha;
                                int ONE_MINALPHA = 256 - malpha;
                                int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                                int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                                int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                                r = (byte)(pred &= 0xFF);
                                g = (byte)(pgreen &= 0xFF);
                                b3 = (byte)(pblue &= 0xFF);
                            } else {
                                r = (byte)(pixVal >> 16 & 0xFF);
                                g = (byte)(pixVal >> 8 & 0xFF);
                                b3 = (byte)(pixVal & 0xFF);
                            }
                            this.pixels[idx] = b3;
                            this.pixels[idx + 1] = g;
                            this.pixels[idx + 2] = r;
                            idx += 3;
                            ++srcIdx;
                            ++overlayIdx;
                        }
                    }
                } else if (clayer instanceof byte[]) {
                    byte[] overlay = (byte[])clayer;
                    if (f != null) {
                        if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlay.length) {
                            this.overlay_bytebuff = new byte[overlay.length];
                            this.overlay_shortbuff = null;
                        }
                        f.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_bytebuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        byte b4;
                        byte g;
                        byte r;
                        pixIdx = bData[srcIdx] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        byte maskIdx = overlay[overlayIdx];
                        if (maskIdx >= 0) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            r = (byte)(pred &= 0xFF);
                            g = (byte)(pgreen &= 0xFF);
                            b4 = (byte)(pblue &= 0xFF);
                        } else {
                            r = (byte)(pixVal >> 16 & 0xFF);
                            g = (byte)(pixVal >> 8 & 0xFF);
                            b4 = (byte)(pixVal & 0xFF);
                        }
                        this.pixels[idx] = b4;
                        this.pixels[idx + 1] = g;
                        this.pixels[idx + 2] = r;
                        idx += 3;
                        ++srcIdx;
                        ++overlayIdx;
                    }
                } else {
                    short[] overlay = (short[])clayer;
                    if (f != null) {
                        if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                            this.overlay_shortbuff = new short[overlay.length];
                            this.overlay_bytebuff = null;
                        }
                        f.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_shortbuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        byte b5;
                        byte g;
                        byte r;
                        pixIdx = bData[srcIdx] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        short maskIdx = overlay[overlayIdx];
                        if (maskIdx >= 0) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            r = (byte)(pred &= 0xFF);
                            g = (byte)(pgreen &= 0xFF);
                            b5 = (byte)(pblue &= 0xFF);
                        } else {
                            r = (byte)(pixVal >> 16 & 0xFF);
                            g = (byte)(pixVal >> 8 & 0xFF);
                            b5 = (byte)(pixVal & 0xFF);
                        }
                        this.pixels[idx] = b5;
                        this.pixels[idx + 1] = g;
                        this.pixels[idx + 2] = r;
                        idx += 3;
                        ++srcIdx;
                        ++overlayIdx;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
            }
        }

        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            int len = sourcePixels.getLength();
            int offset = sourcePixels.getOffset();
            int bpp = sourcePixels.getBPP();
            int mask = (1 << bpp) - 1;
            int endOffset = offset + len;
            int idx = 0;
            int pixIdx = 0;
            short[] sData = sourcePixels.getShortData();
            byte[] bData = sourcePixels.getByteData();
            if (len != this.nPixels) {
                return;
            }
            try {
                if (sData != null) {
                    for (int i = offset; i < endOffset; ++i) {
                        byte b2;
                        int v = sData[i] & mask;
                        pixIdx = v & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        byte r = (byte)(pixVal >> 16 & 0xFF);
                        byte g = (byte)(pixVal >> 8 & 0xFF);
                        this.pixels[idx] = b2 = (byte)(pixVal & 0xFF);
                        this.pixels[idx + 1] = g;
                        this.pixels[idx + 2] = r;
                        idx += 3;
                    }
                } else {
                    for (int i = offset; i < endOffset; ++i) {
                        byte b3;
                        pixIdx = bData[i] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        byte r = (byte)(pixVal >> 16 & 0xFF);
                        byte g = (byte)(pixVal >> 8 & 0xFF);
                        this.pixels[idx] = b3 = (byte)(pixVal & 0xFF);
                        this.pixels[idx + 1] = g;
                        this.pixels[idx + 2] = r;
                        idx += 3;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
            }
        }
    }
}

