/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;

public class XpImageRenderAttributes
implements Cloneable {
    public static final int SCALE_TO_FIT = 100;
    public static final int TRUE_SIZE = 101;
    public static final int MAGNIFY = 102;
    private Point2D cpan = new Point2D.Double();
    private XpImagePixelAttributes ipa = new XpImagePixelAttributes();
    private double zoom = 1.0;
    private int presentationSizeMode = 100;
    private List imageOpList = new ArrayList();
    private XpImageOrientation ior = new XpImageOrientation();
    private XpColorOverlay cOverlay = null;
    private Shape clipShape = null;
    private Shape imageClipShape = null;

    public final XpImagePixelAttributes getImagePixelAttributes() {
        return this.ipa;
    }

    public final double getWindowWidth() {
        return this.ipa.getWindowWidth();
    }

    public final double getWindowLevel() {
        return this.ipa.getWindowLevel();
    }

    public final void setWindowMinMax(double min, double max) {
        this.ipa.setWindowMinMax(min, max);
    }

    public final double getWindowMin() {
        return this.ipa.getWindowMin();
    }

    public final double getWindowMax() {
        return this.ipa.getWindowMax();
    }

    public final void setWindowWidth(double w) {
        this.ipa.setWindowWidth(w);
    }

    public final void setWindowLevel(double l) {
        this.ipa.setWindowLevel(l);
    }

    public final void setWindowing(double ww, double wl) {
        this.ipa.setWindowing(ww, wl);
    }

    public final Point2D getPan() {
        this.cpan.setLocation(this.ior.getPanX(), this.ior.getPanY());
        return this.cpan;
    }

    public final double getPanX() {
        return this.ior.getPanX();
    }

    public final double getPanY() {
        return this.ior.getPanY();
    }

    public final void setPan(Point2D p) {
        this.ior.setPan(p);
    }

    public final void setPan(double panx, double pany) {
        this.ior.setPan(panx, pany);
    }

    public final double getZoom() {
        return this.zoom;
    }

    public final void setZoom(double z) {
        this.zoom = z;
    }

    public final int getPresentationSizeMode() {
        return this.presentationSizeMode;
    }

    public final void setPresentationSizeMode(int presentationSizeMode) {
        this.presentationSizeMode = presentationSizeMode;
    }

    public final double getAngle() {
        return this.ior.getAngle();
    }

    public void setAngle(double a) {
        this.ior.setAngle(a);
    }

    public final IndexColorModel getColormap() {
        return this.ipa.getColormap();
    }

    public void setColormap(IndexColorModel c) {
        this.ipa.setColormap(c);
    }

    public final void setVideoInverted(boolean inverse) {
        this.ipa.setVideoInverted(inverse);
    }

    public final boolean isVideoInverted() {
        return this.ipa.isVideoInverted();
    }

    public final void addImageOperation(XpImageOp imageOp) {
        this.imageOpList.add(imageOp);
    }

    public final void setImageOperationList(List imgOpList) {
        if (imgOpList == this.imageOpList) {
            return;
        }
        this.imageOpList.clear();
        int len = imgOpList.size();
        for (int i = 0; i < len; ++i) {
            Object o = imgOpList.get(i);
            this.imageOpList.add(o);
        }
    }

    public final List getImageOperations() {
        return this.imageOpList;
    }

    public final void clearImageOperations() {
        this.imageOpList.clear();
    }

    public final void clearColorMap() {
        this.ipa.clearColorMap();
    }

    public final void setImageOrientation(XpImageOrientation aior) {
        this.ior.set(aior);
    }

    public final XpImageOrientation getImageOrientation() {
        return this.ior;
    }

    public final void setColorOverlay(XpColorOverlay overlay) {
        this.cOverlay = overlay;
    }

    public final XpColorOverlay getColorOverlay() {
        return this.cOverlay;
    }

    public XpImageRenderAttributes() {
    }

    public XpImageRenderAttributes(XpImageRenderAttributes other) {
        this.set(other);
    }

    public final void set(XpImageRenderAttributes other) {
        this.ipa.set(other.ipa);
        this.zoom = other.zoom;
        this.clipShape = other.clipShape;
        this.imageClipShape = other.imageClipShape;
        this.ior.set(other.ior);
        this.setImageOperationList(other.getImageOperations());
    }

    public Object clone() {
        return new XpImageRenderAttributes(this);
    }

    public final boolean equals(XpImageRenderAttributes other) {
        return this.equalsPixelTransfer(other) && this.equalsGeometry(other);
    }

    public final boolean equalsGeometry(XpImageRenderAttributes other) {
        if (this == other) {
            return true;
        }
        if (this.zoom != other.getZoom()) {
            return false;
        }
        if (this.ior.getPanX() != other.ior.getPanX()) {
            return false;
        }
        if (this.ior.getPanY() != other.ior.getPanY()) {
            return false;
        }
        return this.ior.equals(other.ior);
    }

    public final boolean equalsPixelTransfer(XpImageRenderAttributes other) {
        if (this == other) {
            return true;
        }
        if (!this.ipa.equalsPixelTransfer(other.ipa)) {
            return false;
        }
        return this.cOverlay == other.cOverlay;
    }

    public final boolean equalsPixelTransfer(double windowWidth, double windowLevel, boolean invVideo, IndexColorModel colormap, XpColorOverlay cOverlay) {
        if (!this.ipa.equalsPixelTransfer(windowWidth, windowLevel, invVideo, colormap)) {
            return false;
        }
        return cOverlay == this.cOverlay;
    }

    public final void reset() {
        this.resetAffine();
        this.clipShape = null;
        this.imageClipShape = null;
        this.ipa.reset();
        this.cOverlay = null;
    }

    public final void resetAffine() {
        this.ior.setPan(0.0, 0.0);
        this.zoom = 1.0;
        this.ior.reset();
    }

    public final void resetPixel(double ww, double wl) {
        this.ipa.resetPixel(ww, wl);
        this.cOverlay = null;
    }

    public final Shape getClipShape() {
        return this.clipShape;
    }

    public final void setClipShape(Shape s) {
        this.clipShape = s;
    }

    public final void setImageClip(Shape s) {
        this.imageClipShape = s;
    }

    public final Shape getImageClip() {
        return this.imageClipShape;
    }

    public String toString() {
        double windowWidth = this.ipa.getWindowWidth();
        double windowLevel = this.ipa.getWindowLevel();
        IndexColorModel colormap = this.ipa.getColormap();
        return this.getClass().getName() + ": {" + windowWidth + "W " + windowLevel + "L (" + this.ior.getPanX() + "," + this.ior.getPanY() + ")=pan " + this.zoom + "=zoom " + this.ior.getAngle() + "=angle " + colormap + "=colormap [" + this.clipShape + "]=clipShape [" + this.imageClipShape + "]=imageClipShape}";
    }
}

