/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap;

import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.log.TapLogHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tap {
    public static Logger log = Logger.getLogger("com.ge.med.terra.tap");
    public static int logLevel = Level.WARNING.intValue();
    public static final int LEVEL_SEVERE = Level.SEVERE.intValue();
    public static final int LEVEL_WARNING = Level.WARNING.intValue();
    public static final int LEVEL_INFO = Level.INFO.intValue();
    public static final int LEVEL_CONFIG = Level.CONFIG.intValue();
    public static final int LEVEL_FINE = Level.FINE.intValue();
    public static final int LEVEL_FINER = Level.FINER.intValue();
    public static final int LEVEL_FINEST = Level.FINEST.intValue();
    static Properties props;

    public static void setLogLevel(Level level) {
        log.setLevel(level);
        logLevel = level.intValue();
    }

    public static void setLogLevel(int level) {
        logLevel = level;
        log.setLevel(Level.parse(Integer.toString(level)));
    }

    public static void loadProperties(InputStream istream) {
        try {
            props.load(istream);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot load TAP properties from input stream.", ex);
        }
    }

    public static Properties getProperties() {
        return props;
    }

    public static String getProperty(String name) {
        return props.getProperty(name);
    }

    public static String getProperty(String name, String def) {
        return props.getProperty(name, def);
    }

    public static String setProperty(String name, String val) {
        return (String)props.setProperty(name, val);
    }

    static {
        Handler h = null;
        String name = null;
        try {
            name = System.getProperty("tap.log.handler");
            if (null == name) {
                name = System.getProperty("loghandler");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (name == null) {
            h = new TapLogHandler();
        } else if (!name.equalsIgnoreCase("null")) {
            try {
                Class<?> c = Class.forName(name);
                h = (Handler)c.newInstance();
            }
            catch (IllegalAccessException ex) {
                System.err.println("Not allowed to create class name \"" + name + "\": " + ex);
            }
            catch (InstantiationException ex) {
                System.err.println("Could not create class name \"" + name + "\": " + ex);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Could not find class name \"" + name + "\": " + ex);
            }
        }
        if (h != null) {
            Logger logger = Logger.getLogger("com.ge.med.terra");
            try {
                logger.setUseParentHandlers(false);
                logger.addHandler(h);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            String level = System.getProperty("tap.log.level");
            if (null == level) {
                level = System.getProperty("LogLevel");
            }
            if (level != null) {
                Tap.setLogLevel(Level.parse(level));
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        try {
            InputStream propstream = Class.forName(Tap.class.getName()).getResourceAsStream("tap.properties");
            props = SimpleUtilities.getProperties(propstream, "TAP_CONFIG");
            propstream.close();
        }
        catch (SecurityException ex) {
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Enumeration<Object> e = System.getProperties().keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("tap.")) continue;
                String value = System.getProperty(key);
                log.info("Setting TAP property (" + key + ", " + value + ")");
                props.setProperty(key, value);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

