/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dm.sessionFile.fileComposite;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class DMComposite
implements DMTagValueInterface {
    DMiComposite peer;
    DMSession session;

    public DMComposite(DMiComposite peer, DMSession s) {
        this.peer = peer;
        this.session = s;
    }

    public String getType() {
        return this.peer.getType();
    }

    public Object getValue(DMTag t) {
        Object o = this.peer.getValue(t);
        if (o instanceof DMiSequence) {
            return new DMSequence((DMiSequence)o);
        }
        return o;
    }

    public void getValues(DMElement[] elements) {
        this.peer.getValues(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i].value instanceof DMiSequence)) continue;
            elements[i].value = new DMSequence((DMiSequence)elements[i].value);
        }
    }

    public Object getValue(int group, int element, String privateCID) {
        return this.getValue(new DMTag(privateCID, group, element));
    }

    public Object getValue(int group, int element) {
        return this.getValue(new DMTag(group, element));
    }

    public Object getValue(String tag2) {
        return Util.getValue((DMTagValueInterface)this, (String)tag2);
    }

    public DMiComposite getPeer() {
        return this.peer;
    }

    public BufferedImage[] getPixelData() {
        return this.peer.getPixelData(null);
    }

    public BufferedImage[] getPixelData(DMTag[] tags) {
        return this.peer.getPixelData(tags);
    }

    public void delete() {
        this.peer.delete();
    }

    public void setValues(DMElement[] elements) {
        this.peer.setValues(elements);
    }

    public String getID() {
        return this.peer.getID();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMComposite) {
            return this.getID().equals(((DMComposite)obj).getID());
        }
        return false;
    }

    public InputStream getInputStream() {
        return this.peer.getInputStream();
    }

    public DMImage[] getImages(DMTag[] tags) {
        DMiImage[] o = this.peer.getImages(tags);
        if (o == null) {
            return new DMImage[0];
        }
        DMImage[] img = new DMImage[o.length];
        for (int i = 0; i < o.length; ++i) {
            img[i] = new DMImage(o[i], this.session);
        }
        return img;
    }

    public DMSession getSession() {
        return this.session;
    }

    public String getFilePath() {
        try {
            try {
                return this.peer.getFilePath();
            }
            catch (UnsupportedOperationException e) {
                System.out.println("" + this.peer.getClass().getName() + " does not implement getFilePath!");
                String[] resp = this.session.send("getPESI" + this.getID());
                if (resp != null && resp.length > 0 && resp[0] != null && resp[0].length() > 0 && new File(resp[0]).exists()) {
                    return resp[0];
                }
                resp = this.session.send("GetFilePath" + this.getID());
                if (resp != null && resp.length > 0 && resp[0] != null && resp[0].length() > 0 && new File(resp[0]).exists()) {
                    return resp[0];
                }
                if (this.peer instanceof fileComposite) {
                    return ((fileComposite)this.peer).getFileName();
                }
                File temp = File.createTempFile("tap", "cmp");
                temp.deleteOnExit();
                FileOutputStream out = new FileOutputStream(temp);
                InputStream in = this.getInputStream();
                byte[] chunk = new byte[256];
                int len = in.read(chunk);
                while (len != -1) {
                    out.write(chunk, 0, len);
                    len = in.read(chunk);
                }
                out.close();
                return temp.getAbsolutePath();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

