/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.JdtExtension;
import com.ge.med.terra.tap.util.dicom.jdbDicomDict;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;

public class dicomParser {
    public static final int BIG_LEN = 20000000;
    public boolean noI18N = false;
    boolean brokenGroup2;
    private InputStream istream;
    private boolean littleEndian;
    private boolean explicitVR;
    private boolean forceBigEndianImage;
    private boolean syntaxLock;
    private int off;
    private int fileOff;
    private int buffSize = 8192;
    private int minLeft;
    private int readBlock;
    private byte[] data = new byte[this.buffSize];
    private int bytesInData;
    private boolean noMoreData;
    private boolean exitNow;
    private String fileName;
    private boolean parsingUnknownSequenceAsImplicit = false;
    private String tag_8_5;
    private DicomCharSet[] dicomCharsets;
    public static jdbDicomDict dict = new jdbDicomDict();
    private PrintWriter out = null;

    public dicomParser() {
        this.resetflags();
    }

    public dicomParser(String fname) throws FileNotFoundException {
        this.setFile(fname);
    }

    public dicomParser(FileInputStream fis) throws FileNotFoundException {
        this.setFile(fis);
    }

    private final void resetflags() {
        this.littleEndian = true;
        this.explicitVR = true;
        this.syntaxLock = false;
        this.off = 0;
        this.fileOff = 0;
        this.minLeft = 256;
        this.readBlock = 512;
        this.brokenGroup2 = false;
        this.tag_8_5 = null;
        this.dicomCharsets = DicomCharSet.getDefaultCharSet();
        this.exitNow = false;
        this.noMoreData = false;
        this.forceBigEndianImage = false;
    }

    public final String getFileName() {
        return null != this.fileName && 0 < this.fileName.length() ? this.fileName : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(String fname) throws FileNotFoundException {
        dicomParser dicomParser2 = this;
        synchronized (dicomParser2) {
            try {
                while (this.istream != null) {
                    this.wait();
                }
                if (this.istream != null) {
                    new Exception("This should never happen!!!").printStackTrace();
                }
                this.fileName = fname;
                FileInputStream fileStr = new FileInputStream(this.fileName);
                this.setFile(fileStr, false);
            }
            catch (FileNotFoundException fnfex) {
                this.clearFile();
                throw fnfex;
            }
            catch (Exception ex) {
                String errmsg = "Not a valid DICOM file/stream: " + this.getFileName();
                this.clearFile();
                throw new RuntimeException(errmsg, ex);
            }
        }
    }

    public void setFile(InputStream stream) throws FileNotFoundException {
        this.setFile(stream, true);
    }

    private void setFile(InputStream stream, boolean resetFileName) throws FileNotFoundException {
        if (resetFileName) {
            this.fileName = null;
        }
        this.resetflags();
        this.istream = stream;
        try {
            this.readData(0, this.readBlock);
            if (new String(this.data, 0, 4).equals("DICM")) {
                this.off = 4;
                this.fileOff = 4;
                return;
            }
            if (new String(this.data, 128, 4).equals("DICM")) {
                this.off = 132;
                this.fileOff = 132;
                return;
            }
            tagValue tag2 = new tagValue();
            this.readForTest(tag2);
            if (tag2.group == 0 && tag2.element == 0 && tag2.len == 4) {
                this.off = 0;
                this.fileOff = 0;
                this.explicitVR = false;
                return;
            }
            if (tag2.group == 8 && tag2.element < 255) {
                this.off = 0;
                this.fileOff = 0;
                this.syntaxLock = true;
                if (!vr.isValid(tag2.vrep)) {
                    this.explicitVR = false;
                }
                return;
            }
            this.littleEndian = !this.littleEndian;
            this.readForTest(tag2);
            if (tag2.group == 0 && tag2.element == 0 && tag2.len == 4 || tag2.group == 8 && tag2.element < 255) {
                this.off = 0;
                this.fileOff = 0;
                if (tag2.group == 8) {
                    this.syntaxLock = true;
                }
                return;
            }
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Unable to load input stream: " + this.getFileName(), ex);
        }
        String errmsg = "Not a valid DICOM file/stream: " + this.getFileName();
        this.clearFile();
        throw new FileNotFoundException(errmsg);
    }

    private void readData(int off, int len) throws IOException {
        int dataRead;
        this.bytesInData = off;
        int planToRead = len;
        do {
            if ((dataRead = this.istream.read(this.data, this.bytesInData, planToRead)) == -1) {
                this.noMoreData = true;
                continue;
            }
            this.bytesInData += dataRead;
        } while ((planToRead -= dataRead) > 0 && !this.noMoreData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFile() {
        dicomParser dicomParser2 = this;
        synchronized (dicomParser2) {
            if (this.istream != null) {
                try {
                    this.istream.close();
                }
                catch (IOException ex) {
                    Tap.log.log(Level.WARNING, "Error while closing input stream: " + this.getFileName(), ex);
                }
            }
            this.istream = null;
            this.fileName = null;
            this.notifyAll();
        }
    }

    public boolean isFileLittleEndian() {
        return this.littleEndian;
    }

    public boolean isGuessBigEndian() {
        return !this.littleEndian;
    }

    public boolean isExplicitVR() {
        return this.explicitVR;
    }

    public DicomCharSet[] getDicomCharsets() {
        return this.dicomCharsets;
    }

    private void readForTest(tagValue t) {
        this.guessReadTag(t);
        this.readVR(t);
        this.readValue(t);
    }

    public tagValue readNext() {
        tagValue t = new tagValue();
        if (this.syntaxLock) {
            this.readtag(t);
        } else {
            this.guessReadTag(t);
        }
        this.readVR(t);
        this.refill(t.len);
        this.readValue(t);
        return t;
    }

    public tagValue skipNext() {
        tagValue t = new tagValue();
        if (this.syntaxLock) {
            this.readtag(t);
        } else {
            this.guessReadTag(t);
        }
        this.readVR(t);
        this.refill(t.len);
        this.skipValue(t);
        return t;
    }

    private void readtag(tagValue t) {
        t.fileOffset = this.fileOff;
        t.group = this.read16();
        t.element = this.read16();
    }

    private void guessReadTag(tagValue t) {
        t.fileOffset = this.fileOff;
        t.group = this.read16();
        t.element = this.read16();
        if (t.group > 256) {
            this.littleEndian = !this.littleEndian;
            this.off -= 4;
            this.fileOff -= 4;
            t.group = this.read16();
            t.element = this.read16();
        }
        if (t.group >= 8) {
            this.syntaxLock = true;
        }
    }

    private void readVR(tagValue t) {
        if ((this.explicitVR || t.group == 2) && !this.brokenGroup2) {
            t.vrep = this.readVR();
            if (t.group == 2 && t.element == 0 && t.vrep != 21836) {
                this.off -= 2;
                this.fileOff -= 2;
                t.vrep = 21836;
                this.brokenGroup2 = true;
                t.len = this.read32();
                return;
            }
            if (t.vrep == 0) {
                t.vrep = dicomParser.getVR(t.group, t.element);
            }
            if (t.vrep == 20290 || t.vrep == 20311 || t.vrep == 21329 || t.vrep == 21838) {
                this.off += 2;
                this.fileOff += 2;
                t.len = this.read32();
                if (t.vrep == 21838 && dicomParser.getVR(t.group, t.element) != 0) {
                    t.vrep = dicomParser.getVR(t.group, t.element);
                    if (t.vrep == 21329 && this.explicitVR) {
                        Tap.log.log(Level.WARNING, "Warning: parsingUnknownSequenceAsImplicit {0}", tagValue.atToString(t.group, t.element));
                        this.parsingUnknownSequenceAsImplicit = true;
                        this.explicitVR = false;
                    }
                }
            } else if (t.vrep == 21844 || t.vrep == 20294) {
                this.read16();
                t.len = this.read32();
            } else {
                t.len = this.read16();
            }
            dicomParser.checkSQVR(t, true);
            if (t.group == 8 && t.element == 5) {
                this.tag_8_5 = new String(this.data, this.off, t.len).trim();
                if (this.noI18N || 0 == this.tag_8_5.length()) {
                    this.tag_8_5 = null;
                }
                this.dicomCharsets = DicomCharSet.getDicomCharSets(this.tag_8_5);
            }
            if (t.group == 2 && t.element == 16) {
                String str = new String(this.data, this.off, t.len).trim();
                if ("1.2.840.113619.5.2".equals(str)) {
                    Tap.log.log(Level.INFO, "odd transfer");
                    this.forceBigEndianImage = false;
                    this.explicitVR = false;
                }
                if ("1.2.840.10008.1.2".equals(str)) {
                    this.explicitVR = false;
                } else if ("1.2.840.10008.1.2.2".equals(str)) {
                    this.explicitVR = true;
                    this.littleEndian = false;
                }
            }
        } else {
            t.vrep = dicomParser.getVR(t.group, t.element);
            t.len = this.read32();
            dicomParser.checkSQVR(t, false);
            if (t.group == 8 && t.element == 5) {
                this.tag_8_5 = new String(this.data, this.off, t.len).trim();
                if (this.noI18N || 0 == this.tag_8_5.length()) {
                    this.tag_8_5 = null;
                }
                this.dicomCharsets = DicomCharSet.getDicomCharSets(this.tag_8_5);
            }
            if (t.group == 2 && t.element == 16) {
                String str = new String(this.data, this.off, t.len).trim();
                if ("1.2.840.113619.5.2".equals(str)) {
                    this.forceBigEndianImage = true;
                }
                if ("1.2.840.10008.1.2".equals(str)) {
                    this.explicitVR = false;
                } else if ("1.2.840.10008.1.2.2".equals(str)) {
                    this.explicitVR = true;
                    this.littleEndian = false;
                }
            }
        }
    }

    private void readValue(tagValue t) {
        try {
            if (t.vrep == 21329) {
                int seq_end = t.len != -1 ? this.fileOff + t.len : Integer.MAX_VALUE;
                ArrayList<Object[]> seq = new ArrayList<Object[]>(10);
                while (this.fileOff < seq_end) {
                    int item_end;
                    int seqGroup = this.read16();
                    int seqElem = this.read16();
                    int itemlen = this.read32();
                    if (seqGroup == 65534 && seqElem == 57565) break;
                    ArrayList<tagValue> item = new ArrayList<tagValue>(10);
                    int n = item_end = itemlen != -1 ? this.fileOff + itemlen : Integer.MAX_VALUE;
                    while (this.fileOff < item_end) {
                        this.refill(8);
                        tagValue st = new tagValue();
                        this.readtag(st);
                        if (st.group == 65534 && st.element == 57357) {
                            this.read32();
                            break;
                        }
                        this.refill(st.len);
                        this.readVR(st);
                        this.refill(st.len);
                        this.readValue(st);
                        item.add(st);
                        int old_off = this.fileOff;
                        if (this.fileOff == old_off) continue;
                        item_end -= old_off - this.fileOff;
                        seq_end -= old_off - this.fileOff;
                    }
                    seq.add(item.toArray());
                }
                t.value = seq.toArray();
                if (this.parsingUnknownSequenceAsImplicit) {
                    this.explicitVR = true;
                    this.parsingUnknownSequenceAsImplicit = false;
                }
                return;
            }
            if (t.len < this.buffSize - this.off) {
                if (t.group == 32736 && t.element == 16 && this.forceBigEndianImage) {
                    t.setData(this.data, this.off, false, this.dicomCharsets);
                } else {
                    t.setData(this.data, this.off, this.littleEndian, this.dicomCharsets);
                }
            } else {
                Tap.log.log(Level.WARNING, "len big {0} {1}", new Object[]{t, this.getFileName()});
            }
            this.off += t.len;
            this.fileOff += t.len;
            if (t.vrep == 20290 && t.len == -1) {
                this.exitNow = true;
                Tap.log.log(Level.WARNING, "{0}: vr is ob and t.len == -1; no more data will be parsed", tagValue.atToString(t.group, t.element));
            }
        }
        catch (Exception ex) {
            String errmsg = "Error during readValue(" + t + "): " + this.getFileName();
            this.clearFile();
            throw new RuntimeException(errmsg, ex);
        }
    }

    private void readPtrValue(tagValue t) {
        if (t.vrep == 21329) {
            this.clearFile();
            throw new IllegalArgumentException("Reference For Sequences Not Supported > " + tagValue.atToString(t.group, t.element));
        }
        if (t.group == 32736 && t.element == 16 && this.forceBigEndianImage) {
            t.setLittleEndian(false);
        } else {
            t.setLittleEndian(this.littleEndian);
        }
        this.skip(t.len);
        this.fileOff += t.len;
    }

    private void skipValue(tagValue t) {
        if (t.vrep == 21329) {
            int seq_end = t.len != -1 ? this.fileOff + t.len : Integer.MAX_VALUE;
            tagValue st = new tagValue();
            block0: while (this.fileOff < seq_end && this.hasMoreTags()) {
                int item_end;
                this.refill(8);
                int seqGroup = this.read16();
                int seqElem = this.read16();
                int itemlen = this.read32();
                if (seqGroup == 65534 && seqElem == 57565) break;
                int n = item_end = itemlen != -1 ? this.fileOff + itemlen : Integer.MAX_VALUE;
                while (this.fileOff < item_end && this.hasMoreTags()) {
                    this.readtag(st);
                    if (st.group == 65534 && st.element == 57357) {
                        this.read32();
                        continue block0;
                    }
                    this.readVR(st);
                    this.refill(st.len);
                    this.readValue(st);
                    int old_off = this.fileOff;
                    if (this.fileOff == old_off) continue;
                    item_end -= old_off - this.fileOff;
                    seq_end -= old_off - this.fileOff;
                }
            }
            return;
        }
        this.refill(t.len);
        this.off += t.len;
        this.fileOff += t.len;
    }

    private final int readVR() {
        int t1 = this.data[this.off++] & 0xFF;
        int t2 = this.data[this.off++] & 0xFF;
        this.fileOff += 2;
        return t1 << 8 | t2;
    }

    private final int read16() {
        this.fileOff += 2;
        int res = this.littleEndian ? this.data[this.off++] & 0xFF | (this.data[this.off++] & 0xFF) << 8 : (this.data[this.off++] & 0xFF) << 8 | this.data[this.off++] & 0xFF;
        return res;
    }

    private final int read32() {
        int t1 = this.data[this.off++] & 0xFF;
        int t2 = this.data[this.off++] & 0xFF;
        int t3 = this.data[this.off++] & 0xFF;
        int t4 = this.data[this.off++] & 0xFF;
        this.fileOff += 4;
        long acc = 0L;
        acc = this.littleEndian ? (long)(t1 | t2 << 8 | t3 << 16 | t4 << 24) : (long)(t1 << 24 | t2 << 16 | t3 << 8 | t4);
        return (int)(acc & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean hasMoreTags() {
        if (this.exitNow) {
            return false;
        }
        int bytesUnparsed = this.bytesInData - this.off;
        if (this.noMoreData && bytesUnparsed <= 0) {
            Tap.log.log(Level.FINE, "No More Data = " + this.noMoreData + ", Bytes Unparsed = " + bytesUnparsed + ", " + this.getFileName());
            return false;
        }
        return true;
    }

    public tagValue[] getTags() {
        int maxTags = 200;
        tagValue[] tv = new tagValue[maxTags];
        int j = 0;
        while (this.hasMoreTags()) {
            if (j == maxTags) {
                tagValue[] ntv = new tagValue[maxTags += 100];
                System.arraycopy(tv, 0, ntv, 0, j);
                tv = ntv;
            }
            tv[j++] = this.skipNext();
        }
        tagValue[] rtv = new tagValue[j];
        System.arraycopy(tv, 0, rtv, 0, j);
        return rtv;
    }

    public void fill(tagValue[] tags) {
        tagValue t = new tagValue();
        int fill = 0;
        for (int i = 0; i < tags.length; ++i) {
            tags[i].prepareToFill();
        }
        while (fill < tags.length && this.hasMoreTags()) {
            if (this.syntaxLock) {
                this.readtag(t);
            } else {
                this.guessReadTag(t);
            }
            this.readVR(t);
            if (t.len > 20000000) {
                Tap.log.log(Level.INFO, "big > {0} {1}", new Object[]{t, this.getFileName()});
            }
            boolean readit = false;
            while (fill < tags.length && tags[fill].group < t.group) {
                ++fill;
            }
            if (fill == tags.length) break;
            if (tags[fill].group == t.group) {
                while (fill < tags.length && tags[fill].group == t.group && tags[fill].element < t.element) {
                    ++fill;
                }
                if (fill == tags.length) break;
                if (tags[fill].element == t.element) {
                    tags[fill].vrep = t.vrep;
                    tags[fill].len = t.len;
                    readit = true;
                }
            }
            if (readit) {
                tags[fill].fileOffset = t.fileOffset;
                if (tags[fill].fillValue) {
                    this.refill(tags[fill].len);
                    this.readValue(tags[fill]);
                } else {
                    this.readPtrValue(tags[fill]);
                }
                ++fill;
                continue;
            }
            this.skipValue(t);
        }
    }

    private void refill(int bytesToUse) {
        int planToUse = bytesToUse + 12;
        try {
            int bytesUnparsed = this.bytesInData - this.off;
            if (bytesUnparsed < 0) {
                bytesUnparsed = 0;
            }
            if (bytesUnparsed < this.minLeft || bytesUnparsed <= planToUse) {
                if (planToUse > 20000000) {
                    Tap.log.log(Level.FINEST, "Plan to use {0} bytes: {1}", new Object[]{Integer.toString(planToUse), this.getFileName()});
                }
                if (this.buffSize < planToUse + this.readBlock) {
                    byte[] newdata = new byte[planToUse + this.readBlock];
                    System.arraycopy(this.data, this.off, newdata, 0, bytesUnparsed);
                    this.data = newdata;
                    this.buffSize = planToUse + this.readBlock;
                } else if (this.off > 0) {
                    System.arraycopy(this.data, this.off, this.data, 0, bytesUnparsed);
                }
                int planToRead = planToUse - bytesUnparsed > this.readBlock ? this.readBlock + planToUse - bytesUnparsed : this.readBlock;
                this.readData(bytesUnparsed, planToRead);
                this.off = 0;
            }
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Error while reading DICOM file/stream: ", ex);
        }
        catch (Exception ex) {
            String errmsg = "Error during refill: " + this.getFileName();
            this.clearFile();
            throw new RuntimeException(errmsg, ex);
        }
    }

    private void skip(int bytesToSkip) {
        try {
            int bytesUnparsed = this.bytesInData - this.off;
            if (bytesUnparsed < 0) {
                bytesUnparsed = 0;
            }
            if (bytesUnparsed >= bytesToSkip) {
                System.arraycopy(this.data, this.off + bytesToSkip, this.data, 0, bytesUnparsed - bytesToSkip);
                this.off = 0;
                this.bytesInData = bytesUnparsed - bytesToSkip;
            } else {
                this.off = 0;
                this.bytesInData = 0;
                int skip = 0;
                do {
                    int n = (int)this.istream.skip(bytesToSkip - bytesUnparsed);
                    skip += n;
                    if (n >= 0) continue;
                    this.noMoreData = true;
                } while (skip < bytesToSkip - bytesUnparsed || this.noMoreData);
            }
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Error while reading DICOM file/stream: ", ex);
        }
        this.refill(0);
    }

    @Deprecated
    public static Object extractFromSequence(Object value, String match) {
        tagValue tv = new tagValue();
        tv.value = value;
        return dicomParser.getFromSequence(tv, match, 10);
    }

    public static Object getFromSequence(tagValue tv, String match) {
        Object retval = tv.value;
        String[] split = match.substring(1).split("[\\[\\]\\(\\)]+");
        block0: for (int i = 0; i < split.length && retval != null; ++i) {
            if ((i & 1) == 0) {
                Object[] sq = (Object[])retval;
                int itemNo = Integer.parseInt(split[i]);
                retval = sq[itemNo];
                continue;
            }
            Object[] item = (Object[])retval;
            retval = null;
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                String[] ge = split[i].split(",");
                if (!elem.is(Integer.decode(ge[0].trim()), Integer.decode(ge[1].trim()))) continue;
                retval = elem.value;
                continue block0;
            }
        }
        return retval;
    }

    public static Object getFromSequence(tagValue tv, String match, int radix) {
        Object retval = tv.value;
        String[] split = match.substring(1).split("[\\[\\]\\(\\)]+");
        block0: for (int i = 0; i < split.length && retval != null; ++i) {
            if ((i & 1) == 0) {
                Object[] sq = (Object[])retval;
                int itemNo = Integer.parseInt(split[i]);
                retval = sq[itemNo];
                continue;
            }
            Object[] item = (Object[])retval;
            retval = null;
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                String[] ge = split[i].split(",");
                if (!elem.is(Integer.parseInt(ge[0].trim(), radix), Integer.parseInt(ge[1].trim(), radix))) continue;
                retval = elem.value;
                continue block0;
            }
        }
        return retval;
    }

    @Deprecated
    public static String formatPNtoScreen(String pn) {
        return dicomParser.formatPNtoScreen(pn, false);
    }

    @Deprecated
    public static String formatPNtoScreen(String pn, boolean lastNameFirst) {
        if (pn == null) {
            return null;
        }
        String[] names = pn.split("\\^");
        if (lastNameFirst) {
            switch (names.length - 1) {
                case 0: {
                    return pn;
                }
                case 1: {
                    return names[0] + " " + names[1];
                }
                case 2: {
                    return names[1] + " " + names[2] + " " + names[0];
                }
                case 3: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0];
                }
                case 4: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0] + " " + names[4];
                }
            }
        } else {
            switch (names.length - 1) {
                case 0: {
                    return pn;
                }
                case 1: {
                    return names[1] + " " + names[0];
                }
                case 2: {
                    return names[1] + " " + names[2] + " " + names[0];
                }
                case 3: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0];
                }
                case 4: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0] + " " + names[4];
                }
            }
        }
        return pn;
    }

    public static jdbDicomDict getDictionary() {
        return dict;
    }

    public static void addTag(int group, int element, String description, int vr2, String vm) {
        dict.addTag(group, element, description, vr2, vm);
        try {
            if (Integer.MAX_VALUE == DDictBase.lookupDDict((int)group, (int)element)) {
                DDictBase.addEntry((DDictEntry)new DDictEntry(group, element, JdtExtension.tapToJdtVr((int)vr2), description, vm));
            }
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to update JDT dictionary", e);
        }
    }

    private static int getVR(int g, int e) {
        return dict.getVR(g, e);
    }

    private static void checkSQVR(tagValue t, boolean explicit) {
        if (t.len == -1 && t.group != 32736 && t.vrep == 0) {
            Tap.log.log(Level.WARNING, "{0}: ({1}) sequence of undefined length", new Object[]{tagValue.atToString(t.group, t.element), explicit ? "explicit VR" : "implicit VR"});
            t.vrep = 21329;
        }
    }

    private void printStack(String msg) {
        try {
            if (this.out == null) {
                this.out = new PrintWriter(new FileOutputStream(SimpleUtilities.getTempDir() + File.separator + "parserlog"));
            }
            this.out.println(msg + " ... In thread " + Thread.currentThread().getName());
            StackTraceElement[] stelems = new Exception().getStackTrace();
            for (int i = 1; i < 3; ++i) {
                this.out.println("\ttrace[" + i + "]= " + stelems[i]);
            }
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void dbg(String s) {
        System.out.println(s);
    }

    public static void printSequence(String indent, tagValue tv) {
        Object[] sq = (Object[])tv.value;
        for (int i = 0; i < sq.length; ++i) {
            Object[] item = (Object[])sq[i];
            System.out.println(indent + "------beg seq------");
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                System.out.println(indent + i + ">" + elem);
                if (elem.vrep != 21329) continue;
                dicomParser.printSequence(indent + i + ".", elem);
            }
        }
        System.out.println(indent + "------end seq------");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String[] str = args;
        System.out.println("FILE(S) TO PARSE:");
        for (int i = 0; i < str.length; ++i) {
            System.out.println("     " + str[i]);
        }
        try {
            int i;
            long t1;
            dicomParser dp = new dicomParser();
            int toRead = 55000;
            tagValue[] tv = new tagValue[toRead];
            for (int i2 = 0; i2 < str.length; ++i2) {
                System.out.println("Parsing File: " + str[i2]);
                t1 = System.currentTimeMillis();
                dp.setFile(str[i2]);
                int count = 0;
                while (dp.hasMoreTags()) {
                    tv[count] = dp.readNext();
                    ++count;
                }
                t1 = System.currentTimeMillis() - t1;
                System.out.println("time to read = " + (double)t1 / 1000.0 + "sec");
                System.out.println("-----------------");
                for (int j = 0; j < count; ++j) {
                    if (tv[j].vrep != 21329) {
                        System.out.println(tv[j]);
                        continue;
                    }
                    if (tv[j] == null) continue;
                    System.out.println(tv[j]);
                    dicomParser.printSequence("", tv[j]);
                }
                System.out.println("-----------------");
                dp.clearFile();
            }
            int[][] tags = new int[][]{{8, 5}, {8, 22}, {16, 16}, {16, 32}, {16, 48}, {32, 13}};
            tagValue[] tget = new tagValue[tags.length];
            for (i = 0; i < tags.length; ++i) {
                tget[i] = new tagValue(tags[i][0], tags[i][1]);
            }
            for (i = 0; i < str.length; ++i) {
                System.out.println("Partially Parsing File: " + str[i]);
                t1 = System.currentTimeMillis();
                dp.setFile(str[i]);
                dp.fill(tget);
                dp.clearFile();
                t1 = System.currentTimeMillis() - t1;
                System.out.println("part read time = " + (double)t1 / 1000.0);
                System.out.println("-----------------");
                for (int j = 0; j < tget.length; ++j) {
                    System.out.println(tget[j]);
                }
                System.out.println("-----------------");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }
}

