/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.util.log.TapLogFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class TapLogHandler
extends ConsoleHandler {
    private static final Level DEF_LEVEL = Level.ALL;

    public TapLogHandler() {
        System.err.println("Creating TapLogHandler");
        try {
            this.configure();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void configure() {
        String cname;
        Level level = null;
        Object formatter = null;
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty((cname = this.getClass().getName()) + ".level");
        if (val == null) {
            level = DEF_LEVEL;
        } else {
            try {
                level = Level.parse(val.trim());
            }
            catch (Exception ex) {
                level = DEF_LEVEL;
            }
        }
        this.setLevel(level);
        val = manager.getProperty(cname + ".formatter");
        if (val != null) {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                formatter = (Formatter)clz.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (null == formatter) {
            formatter = new TapLogFormatter();
        }
        this.setFormatter((Formatter)formatter);
    }
}

