/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.color.ColorTable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class XPutil {
    static boolean firstRequest = true;
    public static Logger xpvLogger = Logger.getLogger("com.ge.med.terra.xpv");
    static long lasttime;

    public static ResourceBundle getLocalResourceBundle(String prefix) {
        try {
            ResourceBundle res = ResourceBundle.getBundle(prefix, Locale.getDefault());
            if (res == null) {
                res = ResourceBundle.getBundle(prefix, new Locale("en"));
            }
            return res;
        }
        catch (Exception ex) {
            if (firstRequest) {
                ex.printStackTrace();
                firstRequest = false;
            }
            return ResourceBundle.getBundle(prefix, new Locale("en"));
        }
    }

    private XPutil() {
    }

    public static Logger getLogger() {
        return xpvLogger;
    }

    public static void log(Level l, String s, Throwable ex) {
        xpvLogger.log(l, s, ex);
    }

    public static Object getClassFor(Properties prop, String className, Class classType) {
        try {
            String name = prop.getProperty(className);
            if (name == null) {
                return null;
            }
            Class<?> c = Class.forName(name);
            Object obj = c.newInstance();
            return obj;
        }
        catch (Exception ex) {
            XPutil.getLogger().log(Level.WARNING, "could not load" + className, ex);
            return null;
        }
    }

    public static DMTag[] parseTags(String tagStr) {
        StringTokenizer st = new StringTokenizer(tagStr, "(), ");
        DMTag[] tagList = new DMTag[st.countTokens() / 2];
        int count = 0;
        while (st.hasMoreTokens()) {
            int g = Integer.decode(st.nextToken());
            int e = Integer.decode(st.nextToken());
            tagList[count++] = new DMTag(g, e);
        }
        return tagList;
    }

    public static String[] parseStrings(String str, String token) {
        StringTokenizer st = new StringTokenizer(str, token);
        String[] strs = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            strs[count++] = st.nextToken();
        }
        return strs;
    }

    public static BufferedImage getScreenImage(JComponent port) {
        Dimension d = port.getSize();
        int w = (int)d.getWidth();
        int h = (int)d.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 5);
        Graphics g = bi.getGraphics();
        port.paint(g);
        return bi;
    }

    public static void imageSave(BufferedImage image, String imageFormat, String fileName) {
        try {
            File f = new File(fileName);
            if (f.exists()) {
                System.err.println("deleting" + f.getAbsolutePath());
                f.delete();
            }
            ImageIO.write((RenderedImage)image, imageFormat, f);
            System.err.println("in imageSave....fileName to save===" + fileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            XPutil.getLogger().log(Level.WARNING, "Could not save image into " + fileName, ex);
        }
    }

    public static boolean compareCallBack(double myValue, double callBackValue) {
        double delta = 0.1;
        return !(myValue >= callBackValue - 0.1) || !(myValue <= callBackValue + 0.1);
    }

    public static void time(String str) {
        if (lasttime == 0L) {
            System.out.print("start ");
        }
        System.out.println(str + ":  " + (float)(System.currentTimeMillis() - lasttime) / 1000.0f);
        lasttime = System.currentTimeMillis();
    }

    public static Properties loadXPVAppProperties(InputStream propertyFile) {
        Properties prop = new Properties();
        try {
            prop.load(propertyFile);
            String config = System.getProperties().getProperty("XPVCONFIG");
            if (config != null && !new File(config).exists()) {
                int len;
                FileOutputStream fos = new FileOutputStream(config);
                byte[] buff = new byte[32768];
                while ((len = propertyFile.read(buff)) >= 0) {
                    fos.write(buff, 0, len);
                }
                fos.close();
            } else if (config != null) {
                prop.load(new FileInputStream(config));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XPutil.getLogger().log(Level.INFO, "loading " + propertyFile, ex);
        }
        return prop;
    }

    public static int[] getColorTable(String name) {
        try {
            int[] rgb = new int[256];
            if (name.endsWith(".txt")) {
                LineNumberReader lr = new LineNumberReader(new FileReader(name));
                for (int i = 0; i < rgb.length; ++i) {
                    String line = lr.readLine();
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() != 3) continue;
                    rgb[i] = Integer.parseInt(st.nextToken()) | Integer.parseInt(st.nextToken()) << 8 | Integer.parseInt(st.nextToken()) << 16;
                }
            } else if (name.endsWith(".rgb")) {
                DataInputStream dis = new DataInputStream(new FileInputStream(name));
                for (int i = 0; i < rgb.length; ++i) {
                    int b2 = dis.readInt();
                    int g = dis.readInt();
                    int r = dis.readInt();
                    rgb[i] = r | g << 8 | b2 << 16;
                }
            } else {
                return ColorTable.getColorTable((String)name);
            }
            return rgb;
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        String logLevel = System.getProperty("LogLevel");
        if (logLevel != null && logLevel.equalsIgnoreCase("finest")) {
            xpvLogger.setLevel(Level.FINEST);
        }
        lasttime = 0L;
    }
}

